package com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “商品-满减单价”（减单价）
 * 本政策优惠金额总上限
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardFullminusUnitpriceTotalAmountLimitStrategy extends AbstractTotalAmountLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardFullminusUnitpriceTotalAmountLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策优惠金额总上限";
  }

  @Override
  public String getExpression() {
    return "本政策优惠金额总上限{decimal:input-random:amountLimitValue}元";
  }

}
