package com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “整单-满减总价”（减小计价格）
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardFullminusWholeTotalQuantityLimitStrategy extends AbstractTotalQuantityLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardFullminusWholeTotalQuantityLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策满减商品总数量上限";
  }

  @Override
  public String getExpression() {
    return "本政策满减商品总数量上限{integer:input-integer:quantityLimitValue}销售单位";
  }

}
