package com.biz.crm.dms.business.policy.standard.fullminus.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusSubtotalCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusSubtotalPriceSectionExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusUnitpriceCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusUnitpricePriceSectionExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.WholeFullminusSubtotalCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.WholeFullminusSubtotalPriceSectionExecuteStrategy;

/**
 * 标品提供的-优惠政策-商品满减优惠的实现模块配置
 * @author yinwenjie
 */
@Configuration
@ComponentScan(basePackages = {"com.biz.crm.dms.business.policy.local" , "com.biz.crm.dms.business.policy.standard.fullminus"})
@EntityScan(basePackages = {"com.biz.crm.dms.business.policy.local.entity"})
@EnableJpaRepositories(basePackages = "com.biz.crm.dms.business.policy.local.repository")
public class StandardFullminusConfig {
  
  // ========= 以下和商品满减总价有关
  
  @Bean
  public ProductFullminusSubtotalCountExecuteStrategy getProductFullminusSubtotalCountExecuteStrategy() {
    return new ProductFullminusSubtotalCountExecuteStrategy();
  }
  @Bean
  public ProductFullminusSubtotalPriceSectionExecuteStrategy getProductFullminusSubtotalPriceSectionExecuteStrategy() {
    return new ProductFullminusSubtotalPriceSectionExecuteStrategy();
  }
   
  // ======== 以下和商品满减单价有关 
  @Bean
  public ProductFullminusUnitpriceCountExecuteStrategy getProductFullminusUnitpriceCountExecuteStrategy() {
    return new ProductFullminusUnitpriceCountExecuteStrategy();
  }
  @Bean
  public ProductFullminusUnitpricePriceSectionExecuteStrategy getProductFullminusUnitpricePriceSectionExecuteStrategy() {
    return new ProductFullminusUnitpricePriceSectionExecuteStrategy();
  }
  
  // ======== 以下和整单满减总价有关
  
  @Bean
  public WholeFullminusSubtotalCountExecuteStrategy getWholeFullminusSubtotalCountExecuteStrategy() {
    return new WholeFullminusSubtotalCountExecuteStrategy();
  }
  
  @Bean
  public WholeFullminusSubtotalPriceSectionExecuteStrategy getWholeFullminusSubtotalPriceSectionExecuteStrategy() {
    return new WholeFullminusSubtotalPriceSectionExecuteStrategy();
  }
  
  // ======= 以下是优惠类型模板
  /**
   * DMS标品中提供的 “商品-满减总价” 优惠政策模板注册器
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public StandardFullminusSubtotalTempleteRegister getStandardFullminusSubtotalTempleteRegister() {
    return new StandardFullminusSubtotalTempleteRegister();
  }
  
  /**
   * DMS标品中提供的 “商品-满减单价” 优惠政策模板注册器
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public StandardFullminusUnitpriceTempleteRegister getStandardFullminusUnitpriceTempleteRegister() {
    return new StandardFullminusUnitpriceTempleteRegister();
  }
  
  /**
   * DMS标品中提供的 “整单-满减总价” 优惠政策模板注册器
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public StandardFullminusWholeTempleteRegister getStandardFullminusWholeTempleteRegister() {
    return new StandardFullminusWholeTempleteRegister();
  }
}
