package com.biz.crm.dms.business.policy.standard.fullminus.config;

import com.biz.crm.dms.business.policy.local.characteristic.NotStackingCharacteristicStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.ChannelForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.DistributorForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusSubtotalCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusSubtotalPriceSectionExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusSubtotalCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusSubtotalCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusSubtotalCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusSubtotalCustomerQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusSubtotalTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusSubtotalTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.notifier.StandardFullminusForStickupListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * DMS标品中提供的 “商品-满减总价” 优惠政策模板注册器
 * @author yinwenjie 
 */
public class StandardFullminusSubtotalTempleteRegister implements SalePolicyTempleteRegister { 

  /**
   * 负责“商品-满减”优惠信息运维工作的维护监听器
   */
  @Autowired(required = false)
  private StandardFullminusForStickupListener standardFullminusForStickupListener;
  
  @Override
  public String getType() {
    // 商品-满减总价
    return "standard_fullminus_subtotal_supportproduct";
  }

  @Override
  public String getTypeDesc() {
    return "商品-满减总价";
  }

  @Override
  public Boolean supportProduct() {
    return true;
  }
  
  @Override
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold, ? extends AbstractSalePolicyProductInfo> getStickupListener() {
    return this.standardFullminusForStickupListener;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses() {
    return Sets.newHashSet(DistributorForSalePolicyCustomerScopeStrategy.class , ChannelForSalePolicyCustomerScopeStrategy.class , OrgForSalePolicyCustomerScopeStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses() {
    return Lists.newArrayList(
        StandardFullminusSubtotalCustomerBillQuantityLimitStrategy.class,
        StandardFullminusSubtotalCustomerQuantityLimitStrategy.class,
        StandardFullminusSubtotalTotalQuantityLimitStrategy.class,
        StandardFullminusSubtotalCustomerBillAmountLimitStrategy.class,
        StandardFullminusSubtotalCustomerAmountLimitStrategy.class,
        StandardFullminusSubtotalTotalAmountLimitStrategy.class
    );
  } 
  
  @Override
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses() {
    // 商品满减优惠，有三个优惠执行策略可以使用：满数量减总价、满金额减总价
    return Lists.newArrayList(ProductFullminusSubtotalCountExecuteStrategy.class , ProductFullminusSubtotalPriceSectionExecuteStrategy.class);
  }

  @Override
  public ProductSelectionMethod[] getProductSelectionMethods() {
    // 支持多本品同一规则和多本品不同规则
    return new ProductSelectionMethod[] {ProductSelectionMethod.MULTIPLE , ProductSelectionMethod.SINGLE};
  }
  
  @Override
  public Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    // 设定执行特性
    return Lists.newArrayList(NotStackingCharacteristicStrategy.class);
  }
}
