package com.biz.crm.dms.business.policy.standard.fullminus.config;

import com.biz.crm.dms.business.policy.local.characteristic.NotStackingCharacteristicStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.ChannelForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.DistributorForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusUnitpriceCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.ProductFullminusUnitpricePriceSectionExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusUnitpriceCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusUnitpriceCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusUnitpriceTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusUnitpriceCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusUnitpriceCustomerQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusUnitpriceTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.notifier.StandardFullminusForStickupListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * DMS标品中提供的 “商品-满减单价” 优惠政策模板注册器
 * @author yinwenjie 
 */
public class StandardFullminusUnitpriceTempleteRegister implements SalePolicyTempleteRegister { 

  /**
   * 负责“商品-满减单价”优惠信息运维工作的维护监听器
   * 和负责“商品-满减总价”优惠信息运维工作的维护监听器是一样的
   */
  @Autowired(required = false)
  private StandardFullminusForStickupListener standardFullminusForStickupListener;
  
  @Override
  public String getType() {
    // 商品-满减单价
    return "standard_fullminus_unitprice_supportproduct";
  }

  @Override
  public String getTypeDesc() {
    return "商品-满减单价";
  }

  @Override
  public Boolean supportProduct() {
    return true;
  }
  
  @Override
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold, ? extends AbstractSalePolicyProductInfo> getStickupListener() {
    return this.standardFullminusForStickupListener;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses() {
    return Sets.newHashSet(DistributorForSalePolicyCustomerScopeStrategy.class , ChannelForSalePolicyCustomerScopeStrategy.class , OrgForSalePolicyCustomerScopeStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses() {
    return Lists.newArrayList(
        StandardFullminusUnitpriceCustomerBillQuantityLimitStrategy.class,
        StandardFullminusUnitpriceCustomerQuantityLimitStrategy.class,
        StandardFullminusUnitpriceTotalQuantityLimitStrategy.class,
        StandardFullminusUnitpriceCustomerBillAmountLimitStrategy.class,
        StandardFullminusUnitpriceCustomerAmountLimitStrategy.class,
        StandardFullminusUnitpriceTotalAmountLimitStrategy.class
    );
  } 
  
  @Override
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses() {
    // 商品满减单价优惠，有三个优惠执行策略可以使用：满数量减单价、满金额减单价
    return Lists.newArrayList(ProductFullminusUnitpriceCountExecuteStrategy.class , ProductFullminusUnitpricePriceSectionExecuteStrategy.class);
  }

  @Override
  public ProductSelectionMethod[] getProductSelectionMethods() {
    // 支持多本品同一规则和多本品不同规则
    return new ProductSelectionMethod[] {ProductSelectionMethod.MULTIPLE , ProductSelectionMethod.SINGLE};
  }
  
  @Override
  public Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    // 设定执行特性
    return Lists.newArrayList(NotStackingCharacteristicStrategy.class);
  }
}
