package com.biz.crm.dms.business.policy.standard.fullminus.config;

import com.biz.crm.dms.business.policy.local.characteristic.NotStackingCharacteristicStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.ChannelForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.DistributorForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.WholeFullminusSubtotalCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.WholeFullminusSubtotalPriceSectionExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusWholeCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusWholeCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusWholeCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusWholeCustomerQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusWholeTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy.StandardFullminusWholeTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.fullminus.notifier.StandardFullminusWholeForStickupListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * DMS标品中提供的 “整单-满减总价” 优惠政策模板注册器
 * @author yinwenjie 
 */
public class StandardFullminusWholeTempleteRegister implements SalePolicyTempleteRegister {

  /**
   * 负责整单满减优惠信息运维工作的维护监听器
   */
  @Autowired(required = false)
  private StandardFullminusWholeForStickupListener standardFullminusWholeForStickupListener;

  @Override
  public String getType() {
    // 商品-满减总价
    return "standard_fullminus_subtotal_unsupportproduct";
  }

  @Override
  public String getTypeDesc() {
    return "整单-满减总价";
  }
  
  @Override
  public Boolean supportProduct() {
    return false;
  }

  @Override
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold, ? extends AbstractSalePolicyProductInfo> getStickupListener() {
    return this.standardFullminusWholeForStickupListener;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses() {
    return Sets.newHashSet(DistributorForSalePolicyCustomerScopeStrategy.class , ChannelForSalePolicyCustomerScopeStrategy.class , OrgForSalePolicyCustomerScopeStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses() {
    return Lists.newArrayList(
        StandardFullminusWholeCustomerBillAmountLimitStrategy.class,
        StandardFullminusWholeCustomerAmountLimitStrategy.class,
        StandardFullminusWholeTotalAmountLimitStrategy.class,
        StandardFullminusWholeCustomerBillQuantityLimitStrategy.class,
        StandardFullminusWholeCustomerQuantityLimitStrategy.class,
        StandardFullminusWholeTotalQuantityLimitStrategy.class
    );
  }

  @Override
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses() {
    // 整单满减优惠，有三个优惠执行策略可以使用：满数量减总价、满金额减总价
    return Lists.newArrayList(WholeFullminusSubtotalCountExecuteStrategy.class  , WholeFullminusSubtotalPriceSectionExecuteStrategy.class);
  }

  @Override
  public ProductSelectionMethod[] getProductSelectionMethods() {
    // 整单总价满减不支持选择商品
    return new ProductSelectionMethod[] {ProductSelectionMethod.NOSELECT};
  }

  @Override
  public Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    // 设定执行特性
    return Lists.newArrayList(NotStackingCharacteristicStrategy.class);
  }
}
