package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import org.apache.commons.lang3.StringUtils;

import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

/**
 * 在商品满减优惠方式中使用的，满金额享单价满减的具体优惠执行策略</p>
 * 
 * 2022-05-11 根据产品要求，该执行策略不再使用，不过保留代码
 * 
 * @author yinwenjie
 */
@Deprecated
public class ProductFullminusSubtotalPriceExecuteStrategy extends AbstractFullminusSubtotalPriceExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {

  @Override
  public String getExecuteStrategyCode() {
    return "productFullminusSubtotalPriceExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "满金额享总价满减";
  }

  @Override
  public String getExpression() {
    return "本单中本品金额购买满{decimal:input-integer:fullPriceValue}元，本品总价减{decimal:input-random:priceValue}元";
  }
  
  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000元总价减200，满800元总价减50。那么本品销售金额为1300，则优惠结果为1300 - 200 = 1100";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000元总价减200，满800元总价减50。那么本品销售金额为1300，则优惠结果为1300 - 200 - 50 = 1050";
    }
    return "";
  }
}
