package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在整单优惠方式中使用的，满金额享整单满减的具体优惠执行策略</br>
 * 注意：“满金额享整单满减”和“商品满金额享总价满减”FullminusSubtotalPriceExecuteStrategy，除了描述信息不一样以外、从调用方接收的本品规模不一样，
 * 处理逻辑完全一样。所以可以直接集成AbstractFullminusSubtotalPriceExecuteStrategy即可</p>
 * 
 * 2022-05-11 根据产品要求，该执行策略不再使用，不过保留代码
 * 
 * @author yinwenjie
 */
@Deprecated
public class WholeFullminusSubtotalPriceExecuteStrategy extends AbstractFullminusSubtotalPriceExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override
  public String getExecuteStrategyCode() {
    return "wholePriceFullminusExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "整单满金额享总价满减";
  }

  @Override
  public String getExpression() {
    return "整单本品金额购买满{decimal:input-integer:fullPriceValue}元，整单总价减{decimal:input-random:priceValue}元";
  }
  
  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    // 写死即可
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000元总价减200，满800元总价减50。那么整单销售金额为1300，则优惠结果为1300 - 200 = 1100";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000元总价减200，满800元总价减50。那么整单销售金额为1300，则优惠结果为1300 - 200 - 50 = 1050";
    }
    return "";
  }
}
