package com.biz.crm.dms.business.policy.standard.fullminus.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “商品-满减单价”（减单价）
 * 本政策每客每单优惠金额上限
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardFullminusUnitpriceCustomerBillAmountLimitStrategy extends AbstractCustomerBillAmountLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardFullminusUnitpriceCustomerBillAmountLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策每客每单优惠金额上限";
  }

  @Override
  public String getExpression() {
    return "本政策每客每单优惠金额上限{decimal:input-random:amountLimitValue}元";
  }
}
