package com.biz.crm.dms.business.policy.standard.given.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

/**
 * 标品提供的-优惠政策-商品买赠优惠的实现模块配置
 * @author songjingen
 */
@Configuration
@ComponentScan(basePackages = {"com.biz.crm.dms.business.policy.local" , "com.biz.crm.dms.business.policy.standard.given"})
@EntityScan(basePackages = {"com.biz.crm.dms.business.policy.local.entity"})
@EnableJpaRepositories(basePackages = "com.biz.crm.dms.business.policy.local.repository")
public class StandardGivenConfig {
  // ===== 以下是优惠政策模板
  
  /**
   * DMS标品中提供的商品买赠优惠政策注册器（不关联预算）
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public StandardGivenTempleteRegister getStandardGivenTempleteRegister() {
    return new StandardGivenTempleteRegister();
  }
  
  /**
   * DMS标品中提供的整单买赠优惠政策注册器（不关联预算）
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public StandardWholeGivenTempleteRegister getStandardWholeGivenTempleteRegister() {
    return new StandardWholeGivenTempleteRegister();
  }
}
