package com.biz.crm.dms.business.policy.standard.given.config;

import com.biz.crm.dms.business.policy.standard.given.executestrategy.FullCountGivenPriceExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.given.executestrategy.FullPriceGivenCountExecuteStrategy;
import com.biz.crm.dms.business.policy.local.characteristic.NotStackingCharacteristicStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.ChannelForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.DistributorForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.standard.given.executestrategy.FullCountGivenCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.given.executestrategy.FullPriceGivenPriceExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.given.limitstrategy.StandardGivenGiftCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.given.limitstrategy.StandardGivenGiftCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.given.limitstrategy.StandardGivenGiftCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.given.limitstrategy.StandardGivenGiftCustomerQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.given.limitstrategy.StandardGivenGiftTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.given.limitstrategy.StandardGivenGiftTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.given.notifier.StandardGivenForStickupListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * DMS标品中提供的商品买赠优惠政策注册器（不关联预算）
 * @author songjingen yinwenjie
 */
public class StandardGivenTempleteRegister implements SalePolicyTempleteRegister {

  /**
   * 负责商品买赠优惠信息运维工作的维护监听器
   */
  @Autowired(required = false)
  private StandardGivenForStickupListener standardGivenForStickupListener;
  
  @Override
  public String getType() {
    return "standard_given_supportproduct";
  }

  @Override
  public String getTypeDesc() {
    return "商品买赠";
  }

  @Override
  public Boolean supportProduct() {
    return true;
  }
  
  @Override
  public ProductSelectionMethod[] getProductSelectionMethods() {
    // 支持多本品同一规则和多本品不同规则
    return new ProductSelectionMethod[] {ProductSelectionMethod.MULTIPLE , ProductSelectionMethod.SINGLE};
  }
  
  @Override
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold, ? extends AbstractSalePolicyProductInfo> getStickupListener() {
    return this.standardGivenForStickupListener;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses() {
    // 三种客户范围选择方式都支持
    return Sets.newHashSet(DistributorForSalePolicyCustomerScopeStrategy.class , ChannelForSalePolicyCustomerScopeStrategy.class , OrgForSalePolicyCustomerScopeStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses() {
    return Lists.newArrayList(
        //赠品限量
        StandardGivenGiftCustomerBillQuantityLimitStrategy.class,
        StandardGivenGiftCustomerQuantityLimitStrategy.class,
        StandardGivenGiftTotalQuantityLimitStrategy.class,
        StandardGivenGiftCustomerBillAmountLimitStrategy.class,
        StandardGivenGiftCustomerAmountLimitStrategy.class,
        StandardGivenGiftTotalAmountLimitStrategy.class);
  } 
  
  @Override 
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses() {
    // 商品买赠优惠，有四个优惠执行策略可以使用，满数量赠数量、满数量赠金额、满金额赠数量、满金额赠金额
    return Lists.newArrayList(FullCountGivenCountExecuteStrategy.class , FullCountGivenPriceExecuteStrategy.class, FullPriceGivenCountExecuteStrategy.class, FullPriceGivenPriceExecuteStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    // 设定执行特性
    return Lists.newArrayList(NotStackingCharacteristicStrategy.class);
  }
}
