package com.biz.crm.dms.business.policy.standard.given.cyclestrategy;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 标品默认提供的阶梯循环规则：单阶梯
 * @author yinwenjie
 */
@Component
public class GivenSingleCycleRuleStrategy implements SalePolicyCycleRuleStrategy {

  public final static String GIVEN_SINGLE = "given_single";
  
  @Override
  public String getCycleRuleCode() {
    return GivenSingleCycleRuleStrategy.GIVEN_SINGLE;
  }

  @Override
  public String getCycleRuleDesc() {
    return "单阶梯计算";
  }

  @Override
  public void cycle(AbstractCycleExecuteContext cycleExecuteContext , SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy , SalePolicyVo currentSalePolicy , AbstractSalePolicyExecutorInfo correctAbstractExecutorInfo) {
    DefaultCycleExecuteContext defaultCycleExecuteContext = (DefaultCycleExecuteContext)cycleExecuteContext;
    CycleStepResult cycleStepResult = defaultCycleExecuteContext.findFirstStepResult();
    BigDecimal lastSurplusSubtotalAmount = cycleStepResult.getLastSurplusSubtotalAmount();
    Integer lastSurplusSubtotalNumber = cycleStepResult.getLastSurplusSubtotalNumber();
    /*
     * 单阶梯循环最简单，没有循环:
     * 从第一个阶梯开始，带入具体的执行策略salePolicyExecuteStrategy进行判定
     * 判定成功，则直接执行后退出
     * 如果判定失败，就接着做下一个阶梯的判定，直到所有判定全部失效
     * */
    SalePolicyExecutorVo correctExecutorInfo = (SalePolicyExecutorVo)correctAbstractExecutorInfo;
    Set<SalePolicyExecutorLadderVo> salePolicyExecutorLadders = correctExecutorInfo.getSalePolicyExecutorLadders();
    for(int index = 0 , times = 1 ; index < salePolicyExecutorLadders.size() ; index++) {
      // 如果条件成立，则直接进行执行，并写入执行结果到cycleExecuteContext阶梯执行上下文中
      if(salePolicyExecuteStrategy.execute(cycleExecuteContext , index, times, correctAbstractExecutorInfo)) {
        // 恢复
        CycleStepResult lastStepResult = defaultCycleExecuteContext.findLastStepResult();
        lastStepResult.setLastSurplusSubtotalAmount(lastSurplusSubtotalAmount);
        lastStepResult.setLastSurplusSubtotalNumber(lastSurplusSubtotalNumber);
        return;
      }
    }
  }
}
