package com.biz.crm.dms.business.policy.standard.given.executestrategy;

import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.sharestrategy.GiftShareStrategyWithAmount;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderGiftVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenAccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenMultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenSingleCycleRuleStrategy;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 在商品买赠优惠方式中使用的，满金额赠数量的具体优惠执行策略
 * @author yinwenjie
 */
@Component
public class FullPriceGivenCountExecuteStrategy extends AbstractGivenExecuteStrategy {

  @Override
  public String getExecuteStrategyCode() {
    return "fullPriceGivenCountExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "满金额赠数量";
  }

  @Override
  public String getExpression() {
    return "本单中本品金额购买满{decimal:input-integer:fullPriceValue}元，送赠品";
  }
  
  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, GivenSingleCycleRuleStrategy.GIVEN_SINGLE)) {
      return "例如：满500元送1箱A，满200元送4箱B。若单笔本品金额900元，则送1箱A。";
    } else if(StringUtils.equals(cycleRuleCode, GivenMultipleCycleRuleStrategy.GIVEN_MULTIPLE)) { 
      return "例如：满500元送1箱A，满200元送4箱B。若单笔本品金额900元，则送1箱A，送4箱B。";
    } else if(StringUtils.equals(cycleRuleCode, GivenAccumulationCycleRuleStrategy.GIVEN_ACCUMULATION)) { 
      return "例如：满500元送1箱A，满200元送4箱B。若单笔本品金额900元，则送1箱A，送8箱B。";
    }
    return "";
  }
  
  @Override
  public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy() {
    return GiftShareStrategyWithAmount.class;
  }
  
  @Override
  public void onSaveSalePolicyExecutorInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
     super.onSaveGivenExecutorInfo(update , 1, currentSalePolicy, oldSalePolicy);
  }
  
  protected boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext , int index, int times , Map<String, Object> varParams, SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
    DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
    CycleStepResult lastCycleStepResult = cycleExecuteContext.findLastStepResult();
    // 该变量是指，截止上次优惠后，还有多少本品小计金额没有参加优惠
    BigDecimal lastSurplusSubtotalAmount = lastCycleStepResult.getLastSurplusSubtotalAmount();
    // 这里一定是有值的
    Object fullPriceValueObject = varParams.get("fullPriceValue");
    if(fullPriceValueObject == null) {
      return false;
    }
    Integer fullPriceValue = (Integer)fullPriceValueObject;
    Set<SalePolicyExecutorLadderGiftVo> salePolicyExecutorLadderGifts = salePolicyExecutorLadder.getExecutorLadderGifts();
    // 如果条件成立，说明不满足优惠条件或条件缺失
    if(fullPriceValue > lastSurplusSubtotalAmount.floatValue() || CollectionUtils.isEmpty(salePolicyExecutorLadderGifts)) {
      return false;
    }
    
    // ====== 如果走到这里，说明符合该阶梯的处理前提，开始进行赠品累加
    Set<GiftResultInfo> resultGiftInfos = super.buildGiftResult(lastCycleStepResult ,  cycleExecuteContext.getCustomerCode()  , salePolicyExecutorLadder);
    // 构造新的阶梯优惠步进
    BigDecimal lastSubtotalAmount = lastCycleStepResult.getLastSubtotalAmount();
    Integer lastSurplusSubtotalNumber = lastCycleStepResult.getLastSurplusSubtotalNumber();
    CycleStepResult newCycleStepResult = new CycleStepResult(index, times, lastSubtotalAmount, lastSurplusSubtotalAmount, lastSurplusSubtotalNumber);
    // 本次计算结果对赠品情况进行修改
    BigDecimal result = lastSurplusSubtotalAmount.subtract(new BigDecimal(fullPriceValue));
    newCycleStepResult.setLastSubtotalAmount(lastSubtotalAmount);
    newCycleStepResult.setLastSurplusSubtotalAmount(result);
    newCycleStepResult.setLastSurplusSubtotalNumber(lastSurplusSubtotalNumber);
    newCycleStepResult.setLastGifts(resultGiftInfos);
    cycleExecuteContext.addStepResult(newCycleStepResult);
    return true;
  }
}
