package com.biz.crm.dms.business.policy.standard.given.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “商品买赠”
 * 本政策每客优惠金额上限
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardGivenCustomerAmountLimitStrategy extends AbstractCustomerAmountLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardGivenCustomerAmountLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策每客优惠金额上限";
  }

  @Override
  public String getExpression() {
    return "本政策每客优惠金额上限{decimal:input-random:amountLimitValue}元";
  }

}
