package com.biz.crm.dms.business.policy.standard.given.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractGiftCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “商品买赠”
 * 本政策每客优惠金额上限
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardGivenGiftCustomerAmountLimitStrategy extends AbstractGiftCustomerAmountLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardGivenGiftCustomerAmountLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策每客赠品优惠金额上限";
  }

  @Override
  public String getExpression() {
    return "本政策每客赠品优惠金额上限{decimal:input-random:amountLimitValue}元";
  }

}
