package com.biz.crm.dms.business.policy.standard.given.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractGiftTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “整单买赠”
 * 本政策买赠商品数量上限
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardWholeGivenGiftTotalQuantityLimitStrategy extends AbstractGiftTotalQuantityLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardWholeGivenGiftTotalQuantityLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策买赠商品赠品总数量上限";
  }

  @Override
  public String getExpression() {
    return "本政策买赠商品赠品总数量上限{integer:input-integer:quantityLimitValue}销售单位";
  }

}
