package com.biz.crm.dms.business.policy.standard.given.cyclestrategy;

import java.math.BigDecimal;
import java.util.Set;

import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 标品中专门负责满赠执行的阶梯循环规则：多阶梯</br>
 * 其特点是可以对“剩余未参与优惠的金额和数量”的值进行恢复（标品中的满赠要求不扣减剩余优惠价值）
 * @author yinwenjie
 */
@Component
public class GivenMultipleCycleRuleStrategy implements SalePolicyCycleRuleStrategy {

  public final static String GIVEN_MULTIPLE = "given_multiple";
  
  @Override
  public String getCycleRuleCode() {
    return GivenMultipleCycleRuleStrategy.GIVEN_MULTIPLE;
  }

  @Override
  public String getCycleRuleDesc() {
    return "阶梯叠加计算";
  }

  @Override
  public void cycle(AbstractCycleExecuteContext cycleExecuteContext , SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy , SalePolicyVo currentSalePolicy , AbstractSalePolicyExecutorInfo correctAbstractExecutorInfo) {
    DefaultCycleExecuteContext defaultCycleExecuteContext = (DefaultCycleExecuteContext)cycleExecuteContext;
    CycleStepResult cycleStepResult = defaultCycleExecuteContext.findFirstStepResult();
    BigDecimal lastSurplusSubtotalAmount = cycleStepResult.getLastSurplusSubtotalAmount();
    Integer lastSurplusSubtotalNumber = cycleStepResult.getLastSurplusSubtotalNumber();
    
    /*
     * 循环阶梯处理过程:
     * 从第一个阶梯开始，带入具体的执行策略salePolicyExecuteStrategy进行判定
     * 无论执行判定判定是否成功，都要继续向后执行
     * 只不过执行成功后，times的数值要增加
     * */
    
    SalePolicyExecutorVo correctExecutorInfo = (SalePolicyExecutorVo)correctAbstractExecutorInfo;
    Set<SalePolicyExecutorLadderVo> salePolicyExecutorLadders = correctExecutorInfo.getSalePolicyExecutorLadders();
    for(int index = 0 , times = 1 ; index < salePolicyExecutorLadders.size() ; index++) {
      if(salePolicyExecuteStrategy.execute(cycleExecuteContext , index, times, correctAbstractExecutorInfo)) {
        times++;
      }
    }
    
    // 恢复剩余价值
    CycleStepResult lastStepResult = defaultCycleExecuteContext.findLastStepResult();
    lastStepResult.setLastSurplusSubtotalAmount(lastSurplusSubtotalAmount);
    lastStepResult.setLastSurplusSubtotalNumber(lastSurplusSubtotalNumber);
  }
}
