package com.biz.crm.dms.business.policy.standard.given.executestrategy;

import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.sharestrategy.GiftShareStrategyWithAmount;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderGiftVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenAccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenMultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenSingleCycleRuleStrategy;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 在商品买赠优惠方式中使用的，满数量赠金额的具体优惠执行策略
 * @author yinwenjie
 */
@Component
public class FullCountGivenPriceExecuteStrategy extends AbstractGivenExecuteStrategy {

  @Override
  public String getExecuteStrategyCode() {
    return "fullCountGivenPriceExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "满数量赠金额";
  }

  @Override
  public String getExpression() {
    return "本单中本品数量购买满{integer:input-integer:fullCountValue}销售单位，送赠品";
  }
  
  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, GivenSingleCycleRuleStrategy.GIVEN_SINGLE)) {
      return "例如：满50箱送赠品A 100元，满100箱送赠品B 100元。若单笔订单为150箱，B单价为10元，则送10箱B。";
    } else if(StringUtils.equals(cycleRuleCode, GivenMultipleCycleRuleStrategy.GIVEN_MULTIPLE)) { 
      return "例如：满50箱送赠品A 100元，满100箱送赠品B 100元。若单笔订单为150箱，B单价为10元、A单价为20元，则送10箱B、5箱A。";
    } else if(StringUtils.equals(cycleRuleCode, GivenAccumulationCycleRuleStrategy.GIVEN_ACCUMULATION)) { 
      return "例如：满50箱送赠品A 100元，满100箱送赠品B 100元。若单笔订单为250箱，B单价为10元、A单价为20元，则送20箱B、5箱A。";
    }
    return "";
  }
  
  @Override
  public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy() {
    return GiftShareStrategyWithAmount.class;
  }
  
  @Override
  public void onSaveSalePolicyExecutorInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
     super.onSaveGivenExecutorInfo(update , 2 , currentSalePolicy, oldSalePolicy);
  }
  
  @Override
  protected boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext, int index, int times, Map<String, Object> varParams , SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
    DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
    CycleStepResult lastCycleStepResult = cycleExecuteContext.findLastStepResult();
    // 该变量是指，截止上次优惠后，还有多少本品小计数量没有参加优惠
    Integer lastSurplusSubtotalNumber = lastCycleStepResult.getLastSurplusSubtotalNumber();
    // 这里一定是有值的
    Object fullCountValueObject = varParams.get("fullCountValue");
    if(fullCountValueObject == null) {
      return false;
    }
    Integer fullCountValue = (Integer)fullCountValueObject;
    Set<SalePolicyExecutorLadderGiftVo> salePolicyExecutorLadderGifts = salePolicyExecutorLadder.getExecutorLadderGifts();
    // 如果条件成立，说明不满足优惠条件或条件缺失
    if(fullCountValue > lastSurplusSubtotalNumber || CollectionUtils.isEmpty(salePolicyExecutorLadderGifts)) {
      return false;
    }
    
    // ====== 如果走到这里，说明符合该阶梯的处理前提，开始进行赠品累加
    Set<GiftResultInfo> resultGiftInfos = super.buildGiftResult(lastCycleStepResult ,  cycleExecuteContext.getCustomerCode()  , salePolicyExecutorLadder);
    // 构造新的阶梯优惠步进
    BigDecimal lastSubtotalAmount = lastCycleStepResult.getLastSubtotalAmount();
    BigDecimal lastSurplusSubtotalAmount = lastCycleStepResult.getLastSurplusSubtotalAmount();
    CycleStepResult newCycleStepResult = new CycleStepResult(index, times, lastSubtotalAmount, lastSurplusSubtotalAmount, lastSurplusSubtotalNumber);
    // 本次计算结果对赠品情况进行修改
    Integer result = lastSurplusSubtotalNumber - fullCountValue;
    newCycleStepResult.setLastSubtotalAmount(lastSubtotalAmount);
    newCycleStepResult.setLastSurplusSubtotalAmount(lastSurplusSubtotalAmount);
    newCycleStepResult.setLastSurplusSubtotalNumber(result);
    newCycleStepResult.setLastGifts(resultGiftInfos);
    cycleExecuteContext.addStepResult(newCycleStepResult);
    return true;
  }
}
