/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.standard.given.executestrategy;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.executestrategy.AbstractStandardExecuteStrategy;
import com.biz.crm.dms.business.policy.local.utils.GiftBuildUtils;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderGiftVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenAccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenMultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.standard.given.cyclestrategy.GivenSingleCycleRuleStrategy;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractGivenExecuteStrategy
extends AbstractStandardExecuteStrategy
implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;

    protected void onSaveGivenExecutorInfo(boolean update, Integer requestGiftType, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        Set salePolicyExecutorInfos = currentSalePolicy.getSalePolicyExecutorInfos();
        for (AbstractSalePolicyExecutorInfo abstractSalePolicyExecutorInfo : salePolicyExecutorInfos) {
            SalePolicyExecutorVo salePolicyExecutor = (SalePolicyExecutorVo)abstractSalePolicyExecutorInfo;
            if (!StringUtils.equals((CharSequence)salePolicyExecutor.getExecuteStrategyCode(), (CharSequence)this.getExecuteStrategyCode())) continue;
            Set salePolicyExecutorLadders = salePolicyExecutor.getSalePolicyExecutorLadders();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyExecutorLadders) ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u7ef4\u62a4\u65f6\uff0c\u6bcf\u4e00\u4e2a\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\u90fd\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u9636\u68af\u8bbe\u5b9a", (Object[])new Object[0]);
            for (SalePolicyExecutorLadderVo salePolicyExecutorLadder : salePolicyExecutorLadders) {
                Set executorLadderGifts = salePolicyExecutorLadder.getExecutorLadderGifts();
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)executorLadderGifts) ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u7ef4\u62a4\u65f6\uff0c\u6bcf\u4e00\u4e2a\u4f18\u60e0\u653f\u7b56\u9636\u68af\u90fd\u9700\u8981\u81f3\u5c11\u8bbe\u5b9a\u4e00\u4e2a\u8d60\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                for (SalePolicyExecutorLadderGiftVo executorLadderGift : executorLadderGifts) {
                    Validate.isTrue((executorLadderGift.getGiftType() != null && executorLadderGift.getGiftType().intValue() == requestGiftType.intValue() ? 1 : 0) != 0, (String)"\u6309\u7167\u4f18\u60e0\u653f\u7b56\u6267\u884c\u6027\u8d28\uff0c\u8fd9\u91cc\u7684\u8d60\u54c1\u8d60\u9001\u5f62\u5f0f\u53ea\u80fd\u4f20\u9012\u5339\u914d\u7684\u503c\uff08\u8d60\u9001\u6570\u91cf\uff09", (Object[])new Object[0]);
                }
            }
        }
        this.handleSaveSalePolicyExecutorInfo(update, currentSalePolicy, oldSalePolicy, currentSalePolicy.getSalePolicyExecutorInfos().stream().map(item -> (SalePolicyExecutorVo)item).collect(Collectors.toSet()));
        super.validatetExpressionParams(currentSalePolicy);
    }

    protected Set<GiftResultInfo> buildGiftResult(CycleStepResult lastCycleStepResult, String customerCode, SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
        Set lastGifts = lastCycleStepResult.getLastGifts();
        if (lastGifts == null) {
            lastGifts = Sets.newLinkedHashSet();
        }
        Set salePolicyExecutorLadderGifts = salePolicyExecutorLadder.getExecutorLadderGifts();
        Set giftCodes = salePolicyExecutorLadderGifts.stream().map(SalePolicyExecutorLadderGiftVo::getGiftCode).collect(Collectors.toSet());
        FindPriceDto searchPriceDto = new FindPriceDto();
        searchPriceDto.setUserCode(customerCode);
        searchPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
        searchPriceDto.setProductCodeSet(giftCodes);
        Map giftPriceMapping = this.priceModelVoService.findPrice(searchPriceDto);
        LinkedHashMap newGiftInfoMappings = Maps.newLinkedHashMap();
        LinkedHashSet newGiftInfoCodes = Sets.newLinkedHashSet();
        for (SalePolicyExecutorLadderGiftVo salePolicyExecutorLadderGift : salePolicyExecutorLadderGifts) {
            BigDecimal subtotalAmount;
            String giftCode = salePolicyExecutorLadderGift.getGiftCode();
            String giftName = salePolicyExecutorLadderGift.getGiftName();
            Integer giftValue = salePolicyExecutorLadderGift.getGiftValue();
            Integer giftType = salePolicyExecutorLadderGift.getGiftType();
            PriceModelVo priceModelVo = null;
            BigDecimal giftPrice = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Map)giftPriceMapping) && (priceModelVo = (PriceModelVo)giftPriceMapping.get(giftCode)) != null && priceModelVo.getPrice() != BigDecimal.ZERO) {
                giftPrice = priceModelVo.getPrice();
            }
            int number = 0;
            if (giftType == 1) {
                number = giftValue;
            } else if (giftPrice != BigDecimal.ZERO) {
                number = new BigDecimal(giftValue).divide(giftPrice, 0, RoundingMode.DOWN).intValue();
            }
            GiftResultInfo newGiftResultInfo = new GiftResultInfo();
            newGiftResultInfo.setProductCode(giftCode);
            newGiftResultInfo.setProductName(giftName);
            newGiftResultInfo.setQuantity(Integer.valueOf(number));
            if (number != 0 && giftPrice != BigDecimal.ZERO) {
                subtotalAmount = giftPrice.multiply(new BigDecimal(number)).setScale(4, RoundingMode.HALF_UP);
                newGiftResultInfo.setSubtotalAmount(subtotalAmount);
            } else {
                newGiftResultInfo.setSubtotalAmount(BigDecimal.ZERO);
            }
            subtotalAmount = new BigDecimal(number).multiply(giftPrice);
            newGiftResultInfo.setSubtotalAmount(subtotalAmount);
            newGiftInfoMappings.put(giftCode, newGiftResultInfo);
            newGiftInfoCodes.add(giftCode);
        }
        Set resultGiftInfos = GiftBuildUtils.buildGiftResult((Collection)lastGifts, (Collection)Sets.newHashSet(newGiftInfoMappings.values()));
        return resultGiftInfos;
    }

    public Class<SalePolicyExecutorVo> getSalePolicyExecutorInfoClass() {
        return SalePolicyExecutorVo.class;
    }

    public Collection<Class<? extends SalePolicyCycleRuleStrategy>> getCycleRuleStrategyClasses() {
        return Lists.newArrayList((Object[])new Class[]{GivenSingleCycleRuleStrategy.class, GivenMultipleCycleRuleStrategy.class, GivenAccumulationCycleRuleStrategy.class});
    }

    public List<SalePolicyExecutorVo> onRequestSalePolicyExecutorInfo(String tenantCode, String salePolicyCode) {
        List salePolicyExecutors = this.salePolicyExecutorService.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode, this.getExecuteStrategyCode());
        if (CollectionUtils.isEmpty((Collection)salePolicyExecutors)) {
            return null;
        }
        Collection salePolicyExecutorVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)salePolicyExecutors, SalePolicyExecutor.class, SalePolicyExecutorVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"salePolicyExecutorLadders", "salePolicyExecutorLadders.executorLadderVars", "salePolicyExecutorLadders.executorLadderGifts"});
        return Lists.newArrayList((Iterable)salePolicyExecutorVos);
    }

    public AbstractCycleExecuteContext buildCycleExecuteContext(AbstractPolicyExecuteContext executeContext, String executorCode, Set<SalePolicyConProduct> initPolicyProducts, String customerCode) {
        return super.buildDefaultCycleExecuteContext(executorCode, executeContext, initPolicyProducts, customerCode);
    }
}

