/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.standard.given.notifier;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyProduct;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThreshold;
import com.biz.crm.dms.business.policy.local.notifier.AbstractSalePolicyStickupListener;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyProductRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyProductService;
import com.biz.crm.dms.business.policy.local.service.SalePolicyThresholdService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdDetailVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StandardGivenForStickupListener
extends AbstractSalePolicyStickupListener
implements SalePolicyStickupListener<SalePolicyThresholdVo, SalePolicyProductVo> {
    @Autowired(required=false)
    private SalePolicyThresholdService salePolicyThresholdService;
    @Autowired(required=false)
    private SalePolicyProductService salePolicyProductService;
    @Autowired(required=false)
    private SalePolicyProductRepository salePolicyProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Class<SalePolicyThresholdVo> getSalePolicyProductThresholdClass() {
        return SalePolicyThresholdVo.class;
    }

    public SalePolicyThresholdVo onRequestSalePolicyThreshold(String tenantCode, String salePolicyCode) {
        SalePolicyThreshold salePolicyThreshold = this.salePolicyThresholdService.findBySalePolicyCode(salePolicyCode, tenantCode);
        if (salePolicyThreshold == null) {
            return null;
        }
        SalePolicyThresholdVo salePolicyThresholdVo = (SalePolicyThresholdVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyThreshold, SalePolicyThresholdVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"thresholdDetails", "thresholdDetails.thresholdProducts"});
        List thresholdDetails = salePolicyThresholdVo.getThresholdDetails();
        if (!CollectionUtils.isEmpty((Collection)thresholdDetails)) {
            for (SalePolicyThresholdDetailVo thresholdDetail : thresholdDetails) {
                thresholdDetail.setSalePolicyCode(salePolicyCode);
                thresholdDetail.setTenantCode(tenantCode);
                List thresholdProducts = thresholdDetail.getThresholdProducts();
                if (CollectionUtils.isEmpty((Collection)thresholdProducts)) continue;
                for (SalePolicyThresholdProductVo thresholdProduct : thresholdProducts) {
                    thresholdProduct.setTenantCode(tenantCode);
                    thresholdProduct.setSalePolicyCode(salePolicyCode);
                    thresholdProduct.setThresholdDetailCode(thresholdDetail.getThresholdDetailCode());
                }
            }
        }
        return salePolicyThresholdVo;
    }

    public void onSaveSalePolicyProductThreshold(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy, SalePolicyThresholdVo salePolicyThreshold) {
        super.onSaveSalePolicyProductThreshold(update, currentSalePolicy, oldSalePolicy, salePolicyThreshold);
    }

    public Pair<Map<String, Set<String>>, String> executeThreshold(Set<SalePolicyConProduct> policyConProducts, AbstractPolicyExecuteContext abstractPolicyExecuteContext, AbstractSalePolicyThreshold abstractSalePolicyThreshold) {
        return super.executeThreshold(policyConProducts, abstractPolicyExecuteContext, abstractSalePolicyThreshold);
    }

    public Class<SalePolicyProductVo> getSalePolicyProductInfoClass() {
        return SalePolicyProductVo.class;
    }

    @Transactional
    public void onSaveSalePolicyProductInfo(boolean update, SalePolicyVo currentSalePolicyVo, SalePolicyVo oldSalePolicy, Set<SalePolicyProductVo> salePolicyProductInfos) {
        Collection salePolicyProducts;
        long count;
        Set productInfos;
        if (update && !CollectionUtils.isEmpty((Collection)(productInfos = oldSalePolicy.getSalePolicyProductInfos()))) {
            this.salePolicyProductRepository.deleteByIds(productInfos.stream().map(UuidVo::getId).collect(Collectors.toSet()));
        }
        Validate.isTrue(((count = (salePolicyProducts = this.nebulaToolkitService.copyCollectionByWhiteList(salePolicyProductInfos, SalePolicyProductVo.class, SalePolicyProduct.class, LinkedHashSet.class, ArrayList.class, new String[0])).stream().filter(item -> StringUtils.isBlank((CharSequence)item.getProductCode())).count()) == 0L ? 1 : 0) != 0, (String)"\u5f53\u4fdd\u5b58\u4f18\u60e0\u653f\u7b56\u4e2d\u7684\u5546\u54c1\u672c\u54c1\u4fe1\u606f\u65f6\uff0c\u5176\u4e2d\u7684\u5546\u54c1\u672c\u54c1\u4e1a\u52a1\u7f16\u53f7productCode\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        count = salePolicyProducts.stream().map(SalePolicyProduct::getProductCode).distinct().count();
        Validate.isTrue((count == (long)salePolicyProducts.size() ? 1 : 0) != 0, (String)"\u5f53\u4fdd\u5b58\u4f18\u60e0\u653f\u7b56\u4e2d\u7684\u6267\u884c\u7b56\u7565\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e24\u7ec4\u5546\u54c1\u672c\u54c1\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u7684productCode\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.salePolicyProductService.createBatch((Set)Sets.newLinkedHashSet((Iterable)salePolicyProducts));
    }

    public List<SalePolicyProductVo> onRequestSalePolicyProductInfos(String tenantCode, String salePolicyCode) {
        List salePolicyProducts = this.salePolicyProductService.findBySalePolicyCode(salePolicyCode, tenantCode);
        if (CollectionUtils.isEmpty((Collection)salePolicyProducts)) {
            return null;
        }
        Collection salePolicyProductVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)salePolicyProducts, SalePolicyProduct.class, SalePolicyProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)salePolicyProductVos);
    }
}

