package com.biz.crm.dms.business.policy.standard.special.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “商品单价特价”
 * 本政策每客每单特价商品数量上限
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardSpecialUnitPriceCustomerBillQuantityLimitStrategy extends AbstractCustomerBillQuantityLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardSpecialUnitPriceCustomerBillQuantityLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策每客每单特价商品数量上限";
  }

  @Override
  public String getExpression() {
    return "本政策每客每单特价商品数量上限{integer:input-integer:quantityLimitValue}销售单位";
  }
}
