package com.biz.crm.dms.business.policy.standard.special.limitstrategy;

import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import org.springframework.stereotype.Component;

/**
 * “商品单价特价”
 * 本政策 特价商品数量上限
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Component
public class StandardSpecialUnitPriceTotalQuantityLimitStrategy extends AbstractTotalQuantityLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Override
  public String getLimitStrategyCode() {
    return "standardSpecialUnitPriceTotalQuantityLimitStrategy";
  }

  @Override
  public String getLimitStrategyDesc() {
    return "本政策特价商品总数量上限";
  }

  @Override
  public String getExpression() {
    return "本政策特价商品总数量上限{integer:input-integer:quantityLimitValue}销售单位";
  }

}
