package com.biz.crm.dms.business.policy.standard.special.notifier;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyProduct;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThreshold;
import com.biz.crm.dms.business.policy.local.notifier.AbstractSalePolicyStickupListener;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyProductRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyProductService;
import com.biz.crm.dms.business.policy.local.service.SalePolicyThresholdService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdDetailVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdVo;

import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 商品特价优惠政策模板使用的基本数据维护监听器
 * @author yinwenjie
 */
@Component
public class StandardSpecialForStickupListener extends AbstractSalePolicyStickupListener implements SalePolicyStickupListener<SalePolicyThresholdVo, SalePolicyProductVo>  {
  @Autowired(required = false)
  private SalePolicyThresholdService salePolicyThresholdService;
  @Autowired(required = false)
  private SalePolicyProductService salePolicyProductService;
  @Autowired(required = false)
  private SalePolicyProductRepository salePolicyProductRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  
  // ======= 以下是优惠政策关联的优惠门槛信息
  
  @Override
  public Class<SalePolicyThresholdVo> getSalePolicyProductThresholdClass() {
    return SalePolicyThresholdVo.class;
  }

  @Override
  public SalePolicyThresholdVo onRequestSalePolicyThreshold(String tenantCode , String salePolicyCode) {
    SalePolicyThreshold salePolicyThreshold = this.salePolicyThresholdService.findBySalePolicyCode(salePolicyCode, tenantCode);
    if(salePolicyThreshold == null) {
      return null;
    }
    // 转换成确定的VO后进行返回 
    SalePolicyThresholdVo salePolicyThresholdVo = this.nebulaToolkitService.copyObjectByWhiteList(salePolicyThreshold, SalePolicyThresholdVo.class , LinkedHashSet.class, ArrayList.class, "thresholdDetails","thresholdDetails.thresholdProducts");
    // 完善信息
    List<SalePolicyThresholdDetailVo> salePolicyThresholdDetailVos = salePolicyThresholdVo.getThresholdDetails();
    if(!CollectionUtils.isEmpty(salePolicyThresholdDetailVos)) {
      for (SalePolicyThresholdDetailVo specialPolicyThresholdDetailVo : salePolicyThresholdDetailVos) {
        specialPolicyThresholdDetailVo.setSalePolicyCode(salePolicyCode);
        specialPolicyThresholdDetailVo.setTenantCode(tenantCode);
        String thresholdDetailCode = specialPolicyThresholdDetailVo.getThresholdDetailCode();
        List<SalePolicyThresholdProductVo> thresholdProducts = specialPolicyThresholdDetailVo.getThresholdProducts();
        for (SalePolicyThresholdProductVo specialPolicyThresholdProductVo : thresholdProducts) {
          specialPolicyThresholdProductVo.setTenantCode(tenantCode);
          specialPolicyThresholdProductVo.setSalePolicyCode(salePolicyCode);
          specialPolicyThresholdProductVo.setThresholdDetailCode(thresholdDetailCode);
        }
      }
    }
    return salePolicyThresholdVo;
  }

  @Override
  public void onSaveSalePolicyProductThreshold(boolean update , SalePolicyVo currentSalePolicy , SalePolicyVo oldSalePolicy, SalePolicyThresholdVo salePolicyThreshold) {
    super.onSaveSalePolicyProductThreshold(update, currentSalePolicy, oldSalePolicy, salePolicyThreshold);
  }
  
  @Override
  public Pair<Map<String,Set<String>>,String> executeThreshold(Set<SalePolicyConProduct> policyConProducts , AbstractPolicyExecuteContext abstractPolicyExecuteContext , AbstractSalePolicyThreshold abstractSalePolicyThreshold) {
    Pair<Map<String,Set<String>>,String> pair = super.executeThreshold(policyConProducts, abstractPolicyExecuteContext, abstractSalePolicyThreshold);
    return pair;
  }
  
  // ======= 以下是优惠政策关联的优惠本品信息

  @Override
  public Class<SalePolicyProductVo> getSalePolicyProductInfoClass() {
    return SalePolicyProductVo.class;
  }

  @Override
  @Transactional
  public void onSaveSalePolicyProductInfo(boolean update , SalePolicyVo currentSalePolicyVo, SalePolicyVo oldSalePolicy , Set<SalePolicyProductVo> salePolicyProductInfos) {
    /*
     * 1、首先删除指定优惠政策可能存在的商品本品信息，然后再进行添加/重新添加
     * 2、再进行添加
     * */
    
    // 1、======
    if(update) {
      Set<AbstractSalePolicyProductInfo> productInfos = oldSalePolicy.getSalePolicyProductInfos();
      if(!CollectionUtils.isEmpty(productInfos)) {
        this.salePolicyProductRepository.deleteByIds(productInfos.stream().map(AbstractSalePolicyProductInfo::getId).collect(Collectors.toSet()));
      }
    }
    
    // 2、======
    Collection<SalePolicyProduct> salePolicyProducts = this.nebulaToolkitService.copyCollectionByWhiteList(salePolicyProductInfos , SalePolicyProductVo.class, SalePolicyProduct.class, LinkedHashSet.class, ArrayList.class);
    // 检测这些商品信息中的业务编码不重复
    long count = salePolicyProducts.stream().filter(item -> StringUtils.isBlank(item.getProductCode())).count();
    Validate.isTrue(count == 0 , "当保存优惠政策中的商品本品信息时，其中的商品本品业务编号productCode必须填写，请检查!!");
    count = salePolicyProducts.stream().map(SalePolicyProduct::getProductCode).distinct().count();
    Validate.isTrue(count == salePolicyProducts.size() , "当保存优惠政策中的执行策略信息时，发现至少有两组商品本品业务编号信息的productCode重复，请检查!!");
    // 进行批量保存
    this.salePolicyProductService.createBatch(Sets.newLinkedHashSet(salePolicyProducts));
  }
  
  @Override
  public List<SalePolicyProductVo> onRequestSalePolicyProductInfos(String tenantCode , String salePolicyCode) {
    List<SalePolicyProduct> salePolicyProducts = this.salePolicyProductService.findBySalePolicyCode(salePolicyCode, tenantCode);
    if(CollectionUtils.isEmpty(salePolicyProducts)) {
      return null;
    }
    // 开始转换
    Collection<SalePolicyProductVo> salePolicyProductVos = this.nebulaToolkitService.copyCollectionByWhiteList(salePolicyProducts, SalePolicyProduct.class, SalePolicyProductVo.class, LinkedHashSet.class, ArrayList.class);
    return Lists.newArrayList(salePolicyProductVos);
  }
}
