/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.standard.special.executestrategy;

import com.biz.crm.dms.business.policy.local.context.UnitpriceCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorService;
import com.biz.crm.dms.business.policy.local.sharestrategy.UnitpriceShareStrategyWithAmountAndNumber;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceCycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.dms.business.policy.standard.special.executestrategy.AbstractSpecialUnitpriceExecuteStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProductSpecialUnitpriceCountExecuteStrategy
extends AbstractSpecialUnitpriceExecuteStrategy {
    @Autowired(required=false)
    private SalePolicyExecutorService salePolicyExecutorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getExecuteStrategyCode() {
        return "productSpecialUnitpriceCountExecuteStrategy";
    }

    public String getExecuteStrategyDesc() {
        return "\u6ee1\u6570\u91cf\u4eab\u53d7\u5355\u4ef7\u7279\u4ef7";
    }

    public String getExpression() {
        return "\u672c\u5355\u4e2d\u672c\u54c1\u6570\u91cf\u8d2d\u4e70\u6ee1{integer:input-integer:fullCountValue}\u9500\u552e\u5355\u4f4d\uff0c\u5404\u672c\u54c1\u5355\u4ef7{decimal:input-random:priceValue}\u5143";
    }

    public String getCycleRuleExample(String cycleRuleCode) {
        if (StringUtils.equals((CharSequence)cycleRuleCode, (CharSequence)"single")) {
            return "\u4f8b\u5982\uff1a\u6ee11000\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6309\u716780\u5143\u8ba1\u7b97\uff0c\u6ee1500\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6309\u7167120\u5143\u8ba1\u7b97\u3002\u90a3\u4e48\u672c\u54c1\u9500\u552e\u6570\u91cf\u4e3a1300\u5355\u4f4d\u65f6\uff0c\u5219\u603b\u4ef7\u4e3a104000 ";
        }
        return "";
    }

    public Class<SalePolicyExecutorVo> getSalePolicyExecutorInfoClass() {
        return SalePolicyExecutorVo.class;
    }

    public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy() {
        return UnitpriceShareStrategyWithAmountAndNumber.class;
    }

    public Collection<Class<? extends SalePolicyCycleRuleStrategy>> getCycleRuleStrategyClasses() {
        return Lists.newArrayList((Object[])new Class[]{SingleCycleRuleStrategy.class});
    }

    public List<SalePolicyExecutorVo> onRequestSalePolicyExecutorInfo(String tenantCode, String salePolicyCode) {
        List specialPolicyExecutors = this.salePolicyExecutorService.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode, this.getExecuteStrategyCode());
        if (CollectionUtils.isEmpty((Collection)specialPolicyExecutors)) {
            return null;
        }
        Collection specialPolicyExecutorVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)specialPolicyExecutors, SalePolicyExecutor.class, SalePolicyExecutorVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"salePolicyExecutorLadders", "salePolicyExecutorLadders.executorLadderVars"});
        return Lists.newArrayList((Iterable)specialPolicyExecutorVos);
    }

    @Transactional
    public void onSaveSalePolicyExecutorInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        this.handleSaveSalePolicyExecutorInfo(update, currentSalePolicy, oldSalePolicy, currentSalePolicy.getSalePolicyExecutorInfos().stream().map(item -> (SalePolicyExecutorVo)item).collect(Collectors.toSet()));
        super.validatetExpressionParams(currentSalePolicy);
    }

    public AbstractCycleExecuteContext buildCycleExecuteContext(AbstractPolicyExecuteContext abstractExecuteContext, String executorCode, Set<SalePolicyConProduct> initPolicyProducts, String customerCode) {
        return super.buildSpecialUnitpriceCycleExecuteContext(executorCode, abstractExecuteContext, initPolicyProducts, customerCode);
    }

    protected boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext, int index, int times, Map<String, Object> varParams, SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
        UnitpriceCycleExecuteContext cycleExecuteContext = (UnitpriceCycleExecuteContext)abstractCycleExecuteContext;
        UnitpriceCycleStepResult lastCycleStepResult = cycleExecuteContext.findLastStepResult();
        Integer preSurplusSubtotalNumber = lastCycleStepResult.getLastSurplusSubtotalNumber();
        Object fullCountValueObject = varParams.get("fullCountValue");
        Object priceValueObject = varParams.get("priceValue");
        if (fullCountValueObject == null || priceValueObject == null) {
            return false;
        }
        Integer fullCountValue = (Integer)fullCountValueObject;
        BigDecimal priceValue = (BigDecimal)priceValueObject;
        if (fullCountValue > preSurplusSubtotalNumber || priceValue.compareTo(BigDecimal.ZERO) != 1) {
            return false;
        }
        BigDecimal preSubtotalAmount = lastCycleStepResult.getLastSubtotalAmount();
        BigDecimal preSurplusSubtotalAmount = lastCycleStepResult.getLastSurplusSubtotalAmount();
        Set preProducts = lastCycleStepResult.getLastProducts();
        UnitpriceCycleStepResult newUnitpriceCycleStepResult = new UnitpriceCycleStepResult(index, times, preSubtotalAmount, preSurplusSubtotalAmount, preSurplusSubtotalNumber, preProducts);
        BigDecimal newCycleAmountResult = BigDecimal.ZERO;
        LinkedHashSet lastProducts = Sets.newLinkedHashSet();
        for (UnitpriceProduct preSpecialUnitpriceProduct : preProducts) {
            String productCode = preSpecialUnitpriceProduct.getProductCode();
            BigDecimal prePrices = preSpecialUnitpriceProduct.getPrices();
            Integer productNumber = preSpecialUnitpriceProduct.getNumbers();
            BigDecimal lastPrices = null;
            lastPrices = prePrices.compareTo(priceValue) != 1 ? prePrices : priceValue;
            if (lastPrices.compareTo(BigDecimal.ZERO) == -1) {
                lastPrices = BigDecimal.ZERO;
                newCycleAmountResult = newCycleAmountResult.add(BigDecimal.ZERO);
            } else {
                newCycleAmountResult = newCycleAmountResult.add(prePrices.subtract(lastPrices).multiply(new BigDecimal(productNumber)).setScale(4, RoundingMode.HALF_UP));
            }
            UnitpriceProduct lastSpecialUnitpriceProduct = new UnitpriceProduct(productCode, productNumber, lastPrices);
            lastProducts.add(lastSpecialUnitpriceProduct);
        }
        BigDecimal result = preSubtotalAmount.subtract(newCycleAmountResult).setScale(4, RoundingMode.HALF_UP);
        newUnitpriceCycleStepResult.setLastSubtotalAmount(result);
        newUnitpriceCycleStepResult.setLastSurplusSubtotalAmount(result);
        newUnitpriceCycleStepResult.setLastSurplusSubtotalNumber(Integer.valueOf(preSurplusSubtotalNumber - fullCountValue));
        newUnitpriceCycleStepResult.setLastProducts((Set)lastProducts);
        cycleExecuteContext.addStepResult(newUnitpriceCycleStepResult);
        return true;
    }
}

