package com.biz.crm.dms.business.policy.standard.special.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

/**
 * 标品提供的-优惠政策-商品特价优惠的实现模块配置
 * @author songjingen
 */
@Configuration
@ComponentScan(basePackages = {"com.biz.crm.dms.business.policy.local" , "com.biz.crm.dms.business.policy.standard.special"})
@EntityScan(basePackages = {"com.biz.crm.dms.business.policy.local.entity"})
@EnableJpaRepositories(basePackages = "com.biz.crm.dms.business.policy.local.repository")
public class StandardSpecialConfig {

  /**
   * DMS标品中提供的商品单价特价优惠政策注册器
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public StandardSpecialUnitpriceTempleteRegister getStandardSpecialUnitpriceTempleteRegister() {
    return new StandardSpecialUnitpriceTempleteRegister();
  }
  
}
