package com.biz.crm.dms.business.policy.standard.special.config;

import com.biz.crm.dms.business.policy.local.characteristic.NotStackingCharacteristicStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.ChannelForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.DistributorForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.standard.special.executestrategy.ProductSpecialUnitpriceCountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.special.executestrategy.ProductSpecialUnitpricePriceExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.special.limitstrategy.StandardSpecialUnitPriceCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.special.limitstrategy.StandardSpecialUnitPriceCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.special.limitstrategy.StandardSpecialUnitPriceTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.special.limitstrategy.StandardSpecialUnitPriceCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.special.limitstrategy.StandardSpecialUnitPriceCustomerQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.special.limitstrategy.StandardSpecialUnitPriceTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.special.notifier.StandardSpecialForStickupListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * DMS标品中提供的商品单价特价优惠政策注册器
 * @author songjingen yinwenjie
 */
public class StandardSpecialUnitpriceTempleteRegister implements SalePolicyTempleteRegister {

  /**
   * 负责商品特价优惠信息运维工作的维护监听器
   */
  @Autowired(required = false)
  private StandardSpecialForStickupListener standardSpecialForStickupListener;
  
  @Override
  public String getType() {
    return "standard_special_unitprice_supportproduct";
  }

  @Override
  public String getTypeDesc() {
    return "商品-单价特价";
  }

  @Override
  public Boolean supportProduct() {
    return true;
  }
  
  @Override
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold, ? extends AbstractSalePolicyProductInfo> getStickupListener() {
    return this.standardSpecialForStickupListener;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses() {
    return Sets.newHashSet(DistributorForSalePolicyCustomerScopeStrategy.class , ChannelForSalePolicyCustomerScopeStrategy.class , OrgForSalePolicyCustomerScopeStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses() {
    return Lists.newArrayList(
        StandardSpecialUnitPriceCustomerBillAmountLimitStrategy.class,
        StandardSpecialUnitPriceCustomerAmountLimitStrategy.class,
        StandardSpecialUnitPriceTotalAmountLimitStrategy.class,
        StandardSpecialUnitPriceCustomerBillQuantityLimitStrategy.class,
        StandardSpecialUnitPriceCustomerQuantityLimitStrategy.class,
        StandardSpecialUnitPriceTotalQuantityLimitStrategy.class
    );
  }
 
  // ======== 以下是关于执行策略的部分
  
  @Override
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses() {
    // 商品特价优惠，有两个优惠执行策略可以使用，一个是满数量享特价、另一个是满金额享特价
    return Lists.newArrayList(ProductSpecialUnitpriceCountExecuteStrategy.class , ProductSpecialUnitpricePriceExecuteStrategy.class);
  }

  @Override
  public ProductSelectionMethod[] getProductSelectionMethods() {
    // 支持多本品同一规则和多本品不同规则
    return new ProductSelectionMethod[] {ProductSelectionMethod.MULTIPLE , ProductSelectionMethod.SINGLE};
  }
  
  @Override
  public Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    // 设定执行特性
    return Lists.newArrayList(NotStackingCharacteristicStrategy.class);
  }
}
