package com.biz.crm.dms.business.psi.product.local.controller.productstock;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryStockDto;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.DeliveryStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.DeliveryStockVo;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 发货单库存控制器
 * @author: Bao Hongbin
 * @create: 2022-01-20 18:24
 **/
@Api(tags = "发货单库存信息")
@Slf4j
@RestController
@RequestMapping("/v1/psiProduct/deliveryStock")
public class DeliveryStockVoController {
  @Autowired(required = false)
  private DeliveryStockVoService deliveryStockVoService;

  /**
   * 发货单查询库存信息
   * @param list
   * @return
   */
  @PostMapping("findByDeliveryStockDto")
  public Result<List<DeliveryStockVo>> findByDeliveryStockDto(@RequestBody List<DeliveryStockDto> list) {
    try {
      List<DeliveryStockVo> result = this.deliveryStockVoService.findByDeliveryStockDto(list);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据订单编码和行查询库存信息
   * @param list
   * @return
   */
  @PostMapping("findByOrderCodeAndItemCode")
  public Result<List<DeliveryStockVo>> findByOrderCodeAndItemCode(@RequestBody List<DeliveryStockDto> list) {
    try {
      List<DeliveryStockVo> result = this.deliveryStockVoService.findByOrderCodeAndItemCode(list);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
