package com.biz.crm.dms.business.psi.product.local.entity.productstock;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * <p>
 * 商品库存表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductStock", description = "商品库存表")
@TableName("dms_product_stock")
@Entity
@Table(name = "dms_product_stock")
@org.hibernate.annotations.Table(appliesTo = "dms_product_stock", comment = "商品库存表")
public class ProductStock extends TenantFlagOpEntity {


  /**
   * 库存编码
   */
  @ApiModelProperty("库存编码")
  @TableField("stock_code")
  @Column(name = "stock_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 库存编码 '")
  private String stockCode;

  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  @TableField(value = "product_level_code")
  @Column(name = "product_level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品层级编码 '")
  private String productLevelCode;

  /**
   * 商品层级名称
   */
  @ApiModelProperty("商品层级名称")
  @TableField(value = "product_level_name")
  @Column(name = "product_level_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品层级名称 '")
  private String productLevelName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @TableField("product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @TableField("product_name")
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品名称 '")
  private String productName;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  @TableField("warehouse_code")
  @Column(name = "warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库编码 '")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  @TableField("warehouse_name")
  @Column(name = "warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库名称 '")
  private String warehouseName;

  /**
   * 可用库存
   */
  @ApiModelProperty("可用库存")
  @TableField(value = "available_stock")
  @Column(name = "available_stock", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 可用库存 '")
  private BigDecimal availableStock;

  /**
   * 冻结库存
   */
  @ApiModelProperty("冻结库存")
  @TableField(value = "frozen_stock")
  @Column(name = "frozen_stock", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 冻结库存 '")
  private BigDecimal frozenStock;

  /**
   * 全部库存
   */
  @ApiModelProperty("全部库存")
  @TableField(value = "total_stock")
  @Column(name = "total_stock", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 全部库存 '")
  private BigDecimal totalStock;

  /**
   * 类型(商品：product; 物料：material)
   */
  @ApiModelProperty("类型(商品：product; 物料：material)")
  @TableField(value = "type")
  @Column(name = "type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 类型(商品：product; 物料：material) '")
  private String type;
}
