package com.biz.crm.dms.business.psi.product.local.mapper.productstock;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockDetailPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.DeliveryStockVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 商品库存明细表 Mapper 接口
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-11
 */
public interface ProductStockDetailMapper extends BaseMapper<ProductStockDetail> {

  /**
   * 占用库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param page
   * @param paginationDto
   * @param normal
   * @return
   */
  Page<ProductStockDetailVo> findFreezeStockDetailByConditions(Page<ProductStockDetailVo> page,
                                                               @Param("dto") ProductStockDetailPaginationDto paginationDto,
                                                               @Param("delFlag") DelFlagStatusEnum normal);

  /**
   * 库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param page
   * @param paginationDto
   * @param normal
   * @return
   */
  Page<ProductStockDetailVo> findStockOperationDetailByConditions(Page<ProductStockDetailVo> page,
                                                                  @Param("dto") ProductStockDetailPaginationDto paginationDto,
                                                                  @Param("delFlag") DelFlagStatusEnum normal);


  /**
   * 根据订单编码和行查询库存信息
   * @param list
   * @return
   */
  List<DeliveryStockVo> findByOrderCodeAndItemCode(@Param("list") List<String> list);

}
