package com.biz.crm.dms.business.psi.product.local.mapper.store;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.store.ProductStoredBill;
import com.biz.crm.dms.business.psi.product.sdk.dto.store.ProductStoredBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import com.biz.crm.dms.business.psi.product.sdk.vo.store.ProductStoredBillVo;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 商品入库单表 Mapper 接口
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
public interface ProductStoredBillMapper extends BaseMapper<ProductStoredBill> {

  /**
   * 分页查询
   *
   * @param page
   * @param paginationDto
   * @param normal
   * @return
   */
  Page<ProductStoredBillVo> findByConditions(Page<ProductDeliveryBillVo> page,
                                             @Param("dto") ProductStoredBillPaginationDto paginationDto,
                                             @Param("delFlag") DelFlagStatusEnum normal);
}
