package com.biz.crm.dms.business.psi.product.local.register.delivery.internal;
/**
 * Created by Bao Hongbin on 2022-01-13 14:57.
 */

import com.biz.crm.dms.business.psi.product.local.constant.SaleDeliverConstant;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockService;
import com.biz.crm.dms.business.psi.product.sdk.common.constant.ProductStockConstant;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.DeliveryProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.register.delivery.DeliveryBillProductStockRegister;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

/**
 * @program: crm-dms
 * @description: 其他出库物料库存操作注册器实现
 * @author: Bao Hongbin
 * @create: 2022-01-13 14:57
 **/
@Service("OtherDeliverMaterialStockRegister")
public class OtherDeliverMaterialStockRegister implements DeliveryBillProductStockRegister {

  /**
   * @see com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType
   */
  private final String OPERATION_TYPE = "MATERIAL_OTHER_DELIVER";

  private final String VOID_OPERATION_TYPE = "VOID_MATERIAL_OTHER_DELIVER";

  @Autowired(required = false)
  private ProductStockService productStockService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private RedisMutexService redisMutexService;

  @Override
  public String getOperationType() {
    return OPERATION_TYPE;
  }

  @Override
  @Transactional
  public ProductStockVo execute(DeliveryProductStockOperationDto operationDto) {
    Validate.notNull(operationDto.getWarehouseCode(), "变更库存物料数量时仓库编码不能为空");
    Validate.notNull(operationDto.getProductCode(), "变更库存物料数量时商品编码不能为空");
    Validate.notNull(operationDto.getQuantity(), "变更库存物料数量不能为空");
    ProductStockOperationDto productStockOperationDto = nebulaToolkitService.copyObjectByWhiteList(
        operationDto, ProductStockOperationDto.class, HashSet.class, ArrayList.class);
    //添加分布式锁
    String s = String.format(ProductStockConstant.PRODUCT_STOCK_LOCK,
        productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode());
    Validate.isTrue(this.redisMutexService.tryLock(s, TimeUnit.MILLISECONDS, 5000),
        SaleDeliverConstant.SALE_DELIVER_LOCK_MESSAGE);
    try {
      //设置库存操作类型
      productStockOperationDto.setProductStockOperationType(OPERATION_TYPE);
      //出库
      ProductStock productStock = productStockService.deliver(productStockOperationDto);
      ProductStockVo productStockVo = nebulaToolkitService.copyObjectByWhiteList(
          productStock, ProductStockVo.class, HashSet.class, ArrayList.class);
      return productStockVo;
    } finally {
      //事务提交或回滚后解锁
      this.redisMutexService.unlock(s);
    }
  }

  @Override
  @Transactional
  public ProductStockVo rescind(DeliveryProductStockOperationDto operationDto) {
    Validate.notNull(operationDto.getWarehouseCode(), "变更库存物料数量时仓库编码不能为空");
    Validate.notNull(operationDto.getProductCode(), "变更库存物料数量时商品编码不能为空");
    Validate.notNull(operationDto.getQuantity(), "变更库存物料数量不能为空");
    ProductStockOperationDto productStockOperationDto = nebulaToolkitService.copyObjectByWhiteList(
        operationDto, ProductStockOperationDto.class, HashSet.class, ArrayList.class);
    TransactionStatus transactionStatus = null;
    //添加分布式锁
    String s = String.format(ProductStockConstant.PRODUCT_STOCK_LOCK,
        productStockOperationDto.getWarehouseCode(), productStockOperationDto.getProductCode());
    Validate.isTrue(this.redisMutexService.tryLock(s, TimeUnit.MILLISECONDS, 5000),
        SaleDeliverConstant.SALE_DELIVER_LOCK_MESSAGE);
    try {
      //设置库存操作类型
      productStockOperationDto.setProductStockOperationType(VOID_OPERATION_TYPE);
      //入库
      ProductStock productStock = productStockService.store(productStockOperationDto);
      ProductStockVo productStockVo = nebulaToolkitService.copyObjectByWhiteList(
          productStock, ProductStockVo.class, HashSet.class, ArrayList.class);
      return productStockVo;
    } finally {
      //事务提交或回滚后解锁
      this.redisMutexService.unlock(s);
    }
  }
}
