package com.biz.crm.dms.business.psi.product.local.repository.delivery;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.psi.product.local.entity.delivery.ProductDeliveryBillDetail;
import com.biz.crm.dms.business.psi.product.local.mapper.delivery.ProductDeliveryBillDetailMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 商品出库单明细表 服务实现类
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Component
public class ProductDeliveryBillDetailRepository extends ServiceImpl<ProductDeliveryBillDetailMapper, ProductDeliveryBillDetail> {

  /**
   * 根据单据id查询详情
   *
   * @param id
   * @return
   */
  public List<ProductDeliveryBillDetail> findListByBillId(String id) {
    return this.lambdaQuery().eq(ProductDeliveryBillDetail::getDeliveryBillId, id).list();
  }

  /**
   * 根据单据id删除详情
   *
   * @param id
   */
  public void deleteByBillId(String id) {
    this.lambdaUpdate().eq(ProductDeliveryBillDetail::getDeliveryBillId, id).remove();
  }
}
