package com.biz.crm.dms.business.psi.product.local.repository.store;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.psi.product.local.entity.store.ProductStoredBillDetail;
import com.biz.crm.dms.business.psi.product.local.mapper.store.ProductStoredBillDetailMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 商品入库单明细表 服务实现类
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Component
public class ProductStoredBillDetailRepository extends ServiceImpl<ProductStoredBillDetailMapper, ProductStoredBillDetail> {

  /**
   * 根据单据id查询详情
   *
   * @param id
   * @return
   */
  public List<ProductStoredBillDetail> findListByBillId(String id) {
    return this.lambdaQuery().eq(ProductStoredBillDetail::getStoredBillId, id).list();
  }

  /**
   * 根据单据id删除详情
   *
   * @param id
   */
  public void deleteByBillId(String id) {
    this.lambdaUpdate().eq(ProductStoredBillDetail::getStoredBillId, id).remove();
  }

  /**
   * 通过id集合查询
   * @param ids
   */
  public  List<ProductStoredBillDetail>  findListByBillIds(List<String> ids) {
    return this.lambdaQuery().in(ProductStoredBillDetail::getStoredBillId, ids).list();
  }
}
