package com.biz.crm.dms.business.psi.product.local.service.productstock.internal;
/**
 * Created by Bao Hongbin on 2022-01-13 19:01.
 */

import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStockDetail;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockDetailRepository;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockDetailService;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 商品库存明细服务实现
 * @author: Bao Hongbin
 * @create: 2022-01-13 19:01
 **/
@Service
public class ProductStockDetailServiceImpl implements ProductStockDetailService {
  @Autowired(required = false)
  private ProductStockDetailRepository productStockDetailRepository;

  @Override
  public List<ProductStockDetail> findListByOrderCode(String orderCode, ProductStockOperation operation) {
    return productStockDetailRepository.findListByOrderCode(orderCode, operation, TenantUtils.getTenantCode());
  }

  @Override
  public void updateWarehouseMsg(String warehouseCode, String warehouseName) {
    Validate.isTrue(StringUtils.isNoneBlank(warehouseCode,warehouseName),"更新库存信息，缺失仓库编码或者仓库名称");
    this.productStockDetailRepository.updateWarehouseMsg(warehouseCode,warehouseName);
  }
}
