package com.biz.crm.dms.business.psi.product.local.service.productstock.notifier;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.repository.productstock.ProductStockRepository;
import com.biz.crm.mdm.business.material.sdk.event.MaterialEventListener;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialEventVo;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
public class MaterialEventListenerImpl implements MaterialEventListener {
    @Autowired(required = false)
    private ProductStockRepository productStockRepository;

    @Override
    public void onDelete(MaterialEventVo materialEventVo) {
        //不需要实现
    }

    @Override
    public void onEnable(MaterialEventVo materialEventVo) {
        /**
         * 启用事件
         */
        List<MaterialVo> list = materialEventVo.getMaterialVos();
        List<String> materialCode = list.stream().map(MaterialVo::getMaterialCode).collect(Collectors.toList());
        List<ProductStock> lists = this.productStockRepository.findByMaterialCode(materialCode);
        Validate.notNull(lists, "无法找到对应的物料的库存数据");
        this.productStockRepository.updateEnableStatusByMaterialCode(EnableStatusEnum.ENABLE,materialCode);
    }

    @Override
    public void onDisable(MaterialEventVo materialEventVo) {
        /**
         * 禁用事件
         */
        List<MaterialVo> list = materialEventVo.getMaterialVos();
        List<String> materialCode = list.stream().map(MaterialVo::getMaterialCode).collect(Collectors.toList());
        List<ProductStock> lists = this.productStockRepository.findByMaterialCode(materialCode);
        Validate.notNull(lists, "无法找到对应的物料的库存数据");
        this.productStockRepository.updateEnableStatusByMaterialCode(EnableStatusEnum.DISABLE,materialCode);
    }

    @Override
    public void onChange(MaterialEventVo materialEventVo) {
        //不需要实现
    }
}
