package com.biz.crm.dms.business.psi.product.local.controller.delivery;
/**
 * Created by Bao Hongbin on 2022-01-20 18:26.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductDeliveryBillVoService;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillCreateDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillUpdateDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 商品出库单控制器
 * @author: Bao Hongbin
 * @create: 2022-01-20 18:26
 **/
@Api(tags = "商品出库单：ProductDeliveryBillVo：与商品出库单相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/psiproduct/deliverybill")
public class ProductDeliveryBillVoController {
  @Autowired(required = false)
  private ProductDeliveryBillVoService productDeliveryBillVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<ProductDeliveryBillVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "paginationDto", value = "分页Dto") ProductDeliveryBillPaginationDto paginationDto) {
    try {
      Page<ProductDeliveryBillVo> result = this.productDeliveryBillVoService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照ProductLevel实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/findDetailsById")
  public Result<ProductDeliveryBillVo> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      ProductDeliveryBillVo result = this.productDeliveryBillVoService.findDetailsById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照实体中的code进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param code
   */
  @ApiOperation(value = "按照实体中的code进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/findDetailsByCode")
  public Result<ProductDeliveryBillVo> findDetailsByCode(@RequestParam("code") @ApiParam("编码") String code) {
    try {
      ProductDeliveryBillVo result = this.productDeliveryBillVoService.findDetailsByCode(code);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建模型中的基本信息以外，还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：
   * 基于模型的创建操作传入的JSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建模型中的基本信息以外，" +
      "还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：基于模型的创建操作传入的JSON对象，" +
      "其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value = "")
  public Result<ProductDeliveryBillVo> create(
      @RequestBody @ApiParam(name = "createDto",
          value = "相关的创建过程，http接口。请注意该创建过程除了可以创建模型中的基本信息以外，" +
              "还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：基于模型的创建操作传入的JSON对象，" +
              "其主键信息不能有值，服务端将会自动为其赋予相关值。" +
              "另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") ProductDeliveryBillCreateDto createDto) {
    try {
      ProductDeliveryBillVo current = this.productDeliveryBillVoService.create(createDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，
   * 包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，
   * 虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（的修改操作传入的SON对象，
   * 其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，" +
      "包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，" +
      "但需要开发人员自行在Service层完善其更新过程注意：基于模型的修改操作传入的JSON对象，其主键信息必须有值，" +
      "服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value = "")
  public Result<ProductDeliveryBillVo> update(
      @RequestBody @ApiParam(name = "updateDto",
          value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，" +
              "包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，" +
              "虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型的修改操作传入的JSON对象，" +
              "其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，" +
              "系统将返回该对象的基本信息（不包括任何关联信息）") ProductDeliveryBillUpdateDto updateDto) {
    try {
      ProductDeliveryBillVo current = this.productDeliveryBillVoService.update(updateDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 删除
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.productDeliveryBillVoService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 出库
   */
  @ApiOperation(value = "出库")
  @DeleteMapping("/handleDeliveryBatch")
  public Result<?> handleDeliveryBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.productDeliveryBillVoService.handleDeliveryBatch(ids);
      return Result.ok("出库成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 驳回出库
   */
  @ApiOperation(value = "驳回出库")
  @DeleteMapping("/handleRejectedBatch")
  public Result<?> handleRejectedBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.productDeliveryBillVoService.handleRejectedBatch(ids);
      return Result.ok("驳回成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 作废
   */
  @ApiOperation(value = "作废")
  @DeleteMapping("/handleVoidBatch")
  public Result<?> handleVoidBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.productDeliveryBillVoService.handleVoidBatch(ids);
      return Result.ok("作废成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
