package com.biz.crm.dms.business.psi.product.local.controller.productstock;
/**
 * Created by Bao Hongbin on 2022-01-20 18:25.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockDetailVoService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockDetailPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 商品库存明细控制器
 * @author: Bao Hongbin
 * @create: 2022-01-20 18:25
 **/
@Api(tags = "商品库存明细：ProductStockDetailVo：与商品库存明细相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/psiproduct/stockdetail")
public class ProductStockDetailVoController {
  @Autowired(required = false)
  private ProductStockDetailVoService productStockDetailVoService;

  /**
   * 占用库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @return
   */
  @ApiOperation(value = "占用库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findFreezeStockDetailByConditions")
  public Result<Page<ProductStockDetailVo>> findFreezeStockDetailByConditions(@PageableDefault(50) Pageable pageable,
                                                                              @ApiParam(name = "paginationDto", value = "分页Dto") ProductStockDetailPaginationDto paginationDto) {
    try {
      Page<ProductStockDetailVo> result = this.productStockDetailVoService.findFreezeStockDetailByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @return
   */
  @ApiOperation(value = "库存明细多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findStockOperationDetailByConditions")
  public Result<Page<ProductStockDetailVo>> findStockOperationDetailByConditions(@PageableDefault(50) Pageable pageable,
                                                                              @ApiParam(name = "paginationDto", value = "分页Dto") ProductStockDetailPaginationDto paginationDto) {
    try {
      Page<ProductStockDetailVo> result = this.productStockDetailVoService.findStockOperationDetailByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据订单编码和行编码查询冻结信息
   * @param orderCode
   * @param orderItemCode
   * @return
   */
  @ApiOperation(value = "根据订单编码和行编码查询冻结信息")
  @GetMapping("findFreezeStockDetailByOrderCodeAndOrderItemCode")
  public Result<List<ProductStockDetailVo>> findFreezeStockDetailByOrderCodeAndOrderItemCode(
          @ApiParam(name = "orderCode", value = "订单编码") String orderCode,
          @ApiParam(name = "orderItemCode", value = "订单行编码") String orderItemCode) {
    try {
      List<ProductStockDetailVo> result = this.productStockDetailVoService.findFreezeStockDetailByOrderCodeAndOrderItemCode(orderCode, orderItemCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
