package com.biz.crm.dms.business.psi.product.local.controller.productstock;
/**
 * Created by Bao Hongbin on 2022-01-20 18:24.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 商品库存控制器
 * @author: Bao Hongbin
 * @create: 2022-01-20 18:24
 **/
@Api(tags = "商品库存：ProductStockVo：与商品库存相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/psiproduct/stock")
public class ProductStockVoController {
  @Autowired(required = false)
  private ProductStockVoService productStockVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<ProductStockVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "paginationDto", value = "分页Dto") ProductStockPaginationDto paginationDto) {
    try {
      Page<ProductStockVo> result = this.productStockVoService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据商品编码查询
   * @return
   */
  @ApiOperation(value = "根据商品编码查询")
  @GetMapping("findByProductCodes")
  public Result<List<ProductStockVo>> findByProductCodes(@ApiParam(name = "productCodes", value = "商品编码集合") List<String> productCodes) {
    try {
      List<ProductStockVo> result = this.productStockVoService.findByProductCodes(productCodes);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
