package com.biz.crm.dms.business.psi.product.local.entity.delivery;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.dms.business.psi.product.sdk.enums.delivery.ProductDeliveryStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * <p>
 * 商品出库单表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductDeliveryBill", description = "商品出库单表")
@TableName("dms_product_delivery_bill")
@Entity
@Table(name = "dms_product_delivery_bill")
@org.hibernate.annotations.Table(appliesTo = "dms_product_delivery_bill", comment = "商品出库单表")
public class ProductDeliveryBill extends TenantFlagOpEntity {

  /**
   * 出库单编码
   */
  @ApiModelProperty("出库单编码")
  @TableField("delivery_bill_code")
  @Column(name = "delivery_bill_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库单编码 '")
  private String deliveryBillCode;

  /**
   * 出库时间
   */
  @ApiModelProperty("出库时间")
  @TableField(value = "delivery_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "delivery_time", length = 20, columnDefinition = "datetime COMMENT '出库时间'")
  private Date deliveryTime;

  /**
   * 经办人账号
   */
  @ApiModelProperty("经办人账号")
  @TableField("handler_account")
  @Column(name = "handler_account", length = 60, columnDefinition = "varchar(60) COMMENT '经办人账号'")
  private String handlerAccount;

  /**
   * 经办人姓名
   */
  @ApiModelProperty("经办人姓名")
  @TableField("handler_name")
  @Column(name = "handler_name", length = 60, columnDefinition = "varchar(60) COMMENT '经办人姓名'")
  private String handlerName;

  /**
   * 关联发货单类型
   */
  @ApiModelProperty("关联发货单类型")
  @TableField(value = "relation_shipment_order_type")
  @Column(name = "relation_shipment_order_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联发货单类型 '")
  private String relationShipmentOrderType;

  /**
   * 关联发货单编码
   */
  @ApiModelProperty("关联发货单编码")
  @TableField(value = "relation_shipment_order_code")
  @Column(name = "relation_shipment_order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联发货单编码 '")
  private String relationShipmentOrderCode;

  /**
   * 入库仓库编码
   */
  @ApiModelProperty("入库仓库编码")
  @TableField(value = "store_warehouse_code")
  @Column(name = "store_warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 入库仓库编码 '")
  private String storeWarehouseCode;

  /**
   * 入库仓库名称
   */
  @ApiModelProperty("入库仓库名称")
  @TableField(value = "store_warehouse_name")
  @Column(name = "store_warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 入库仓库名称 '")
  private String storeWarehouseName;

  /**
   * 出库仓库编码
   */
  @ApiModelProperty("出库仓库编码")
  @TableField(value = "delivery_warehouse_code")
  @Column(name = "delivery_warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库仓库编码 '")
  private String deliveryWarehouseCode;

  /**
   * 出库仓库名称
   */
  @ApiModelProperty("出库仓库名称")
  @TableField(value = "delivery_warehouse_name")
  @Column(name = "delivery_warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库仓库名称 '")
  private String deliveryWarehouseName;

  /**
   * 出库状态
   */
  @ApiModelProperty("出库状态")
  @TableField(value = "delivery_status")
  @Column(name = "delivery_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库状态 '")
  private ProductDeliveryStatus deliveryStatus;

  /**
   * 商品库存操作类型
   */
  @ApiModelProperty("商品库存操作类型")
  @TableField(value = "product_stock_operation_type")
  @Column(name = "product_stock_operation_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品库存操作类型 '")
  private String productStockOperationType;

  /**
   * 类型(商品：product; 物料：material)
   */
  @ApiModelProperty("类型(商品：product; 物料：material)")
  @TableField(value = "type")
  @Column(name = "type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 类型(商品：product; 物料：material) '")
  private String type;
}
