package com.biz.crm.dms.business.psi.product.local.entity.delivery;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * <p>
 * 商品出库单明细表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductDeliveryBillDetail", description = "商品出库单明细表")
@TableName("dms_product_delivery_bill_detail")
@Entity
@Table(name = "dms_product_delivery_bill_detail")
@org.hibernate.annotations.Table(appliesTo = "dms_product_delivery_bill_detail", comment = "商品出库单明细表")
public class ProductDeliveryBillDetail extends TenantOpEntity {


  /**
   * 出库单id
   */
  @ApiModelProperty("出库单id")
  @TableField("delivery_bill_id")
  @Column(name = "delivery_bill_id", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 出库单id '")
  private String deliveryBillId;

  /**
   * 出库单编码
   */
  @ApiModelProperty("出库单编码")
  @TableField(value = "delivery_bill_code")
  @Column(name = "delivery_bill_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库单编码 '")
  private String deliveryBillCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @TableField("customer_code")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户编码 '")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @TableField("customer_name")
  @Column(name = "customer_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户名称 '")
  private String customerName;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  @TableField("original_order_code")
  @Column(name = "original_order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 原始订单编号 '")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @TableField(value = "order_type")
  @Column(name = "order_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单类型 '")
  private String orderType;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @TableField(value = "order_code")
  @Column(name = "order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单编码 '")
  private String orderCode;


  /**
   * 订单行明细编码
   */
  @ApiModelProperty("订单行明细编码")
  @TableField(value = "order_item_code")
  @Column(name = "order_item_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单行明细编码 '")
  private String orderItemCode;

  /**
   * 行项目类型
   */
  @ApiModelProperty("行项目类型")
  @TableField(value = "item_type")
  @Column(name = "item_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 行项目类型 '")
  private String itemType;

  /**
   * 地址
   */
  @ApiModelProperty("地址")
  @TableField(value = "address")
  @Column(name = "address", length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 地址 '")
  private String address;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @TableField(value = "product_name")
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品名称 '")
  private String productName;

  /**
   * 商品规格
   */
  @ApiModelProperty("商品规格")
  @TableField(value = "product_spec")
  @Column(name = "product_spec", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品规格 '")
  private String productSpec;

  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  @TableField(value = "product_unit")
  @Column(name = "product_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品单位 '")
  private String productUnit;

  /**
   * 发货单行项编码
   */
  @ApiModelProperty("发货单行项编码")
  @TableField("shipment_item_code")
  @Column(name = "shipment_item_code", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 发货单行项编码 '")
  private String shipmentItemCode;

  /**
   * 发货单行项总数
   */
  @ApiModelProperty("发货单行项总数")
  @TableField(value = "shipment_item_quantity")
  @Column(name = "shipment_item_quantity", length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 发货单行项总数 '")
  private BigDecimal shipmentItemQuantity;

  /**
   * 发货总数量数
   */
  @ApiModelProperty("发货总数量数")
  @TableField(value = "delivery_quantity")
  @Column(name = "delivery_quantity",  length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 发货总数量数 '")
  private BigDecimal deliveryQuantity;

  /**
   * 本次发货数量
   */
  @ApiModelProperty("本次发货数量")
  @TableField(value = "current_quantity")
  @Column(name = "current_quantity",  length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 本次发货数量 '")
  private BigDecimal currentQuantity;

  /**
   * 已出库数量
   */
  @ApiModelProperty("已出库数量")
  @TableField(value = "delivery_out_quantity")
  @Column(name = "delivery_out_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 已出库数量 '")
  private BigDecimal deliveryOutQuantity;

  /**
   * 待出库数量
   */
  @ApiModelProperty("待出库数量")
  @TableField(value = "deliverying_quantity")
  @Column(name = "deliverying_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 待出库数量 '")
  private BigDecimal deliveryingQuantity;

  /**
   * 出库仓库编码
   */
  @ApiModelProperty("出库仓库编码")
  @TableField(value = "delivery_warehouse_code")
  @Column(name = "delivery_warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库仓库编码 '")
  private String deliveryWarehouseCode;

  /**
   * 出库仓库名称
   */
  @ApiModelProperty("出库仓库名称")
  @TableField(value = "delivery_warehouse_name")
  @Column(name = "delivery_warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库仓库名称 '")
  private String deliveryWarehouseName;
}
