package com.biz.crm.dms.business.psi.product.local.entity.productstock;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Set;

/**
 * <p>
 * 商品安全库存表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductSecurityStock", description = "商品安全库存表")
@TableName("dms_product_security_stock")
@Entity
@Table(name = "dms_product_security_stock")
@org.hibernate.annotations.Table(appliesTo = "dms_product_security_stock", comment = "商品安全库存表")
public class ProductSecurityStock extends TenantFlagOpEntity {


  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @TableField("product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @TableField(value = "product_name")
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品名称 '")
  private String productName;

  /**
   * 商品层级
   */
  @ApiModelProperty("商品层级")
  @TableField(value = "product_level")
  @Column(name = "product_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品层级 '")
  private String productLevel;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  @TableField(value = "spec")
  @Column(name = "spec", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 规格 '")
  private String spec;

  /**
   * 单位
   */
  @ApiModelProperty("单位")
  @TableField(value = "unit")
  @Column(name = "unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 单位 '")
  private String unit;

  @TableField(exist = false)
  @Transient
  private Set<ProductSecurityStockQuantity> securityStockQuantitySet;

}
