package com.biz.crm.dms.business.psi.product.local.entity.productstock;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Set;

/**
 * <p>
 * 商品安全库存数量表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductSecurityStockQuantity", description = "商品安全库存数量表")
@TableName("dms_product_security_stock_quantity")
@Entity
@Table(name = "dms_product_security_stock_quantity")
@org.hibernate.annotations.Table(appliesTo = "dms_product_security_stock_quantity", comment = "商品安全库存数量表")
public class ProductSecurityStockQuantity extends TenantOpEntity {


  /**
   * 安全库存id
   */
  @ApiModelProperty("安全库存id")
  @TableField("security_stock_id")
  @Column(name = "security_stock_id", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 安全库存id '")
  private String securityStockId;

  /**
   * 安全库存数量
   */
  @ApiModelProperty("安全库存数量")
  @TableField(value = "security_stock_quantity")
  @Column(name = "security_stock_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 安全库存数量 '")
  private BigDecimal securityStockQuantity;

  /**
   * 是否适用所有仓库
   */
  @ApiModelProperty("是否适用所有仓库")
  @TableField("applicable_to_all")
  @Column(name = "applicable_to_all", nullable = false, length = 1, columnDefinition = "INT(1) COMMENT ' 是否适用所有仓库 '")
  private Boolean applicableToAll;

  /**
   * 排序
   */
  @ApiModelProperty("排序")
  @TableField("sort")
  @Column(name = "sort", nullable = false, length = 11, columnDefinition = "INT(11) COMMENT ' 排序 '")
  private Integer sort;


  @TableField(exist = false)
  @Transient
  private ProductSecurityStock productSecuritystock;

  @TableField(exist = false)
  @Transient
  private Set<ProductSecurityStockQuantityWarehouse> securityStockQuantityWarehouseSet;
}
