package com.biz.crm.dms.business.psi.product.local.entity.productstock;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * <p>
 * 商品安全库存数量适用仓库表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductSecurityStockQuantityWarehouse", description = "商品安全库存数量适用仓库表")
@TableName("dms_product_security_stock_quantity_warehouse")
@Entity
@Table(name = "dms_product_security_stock_quantity_warehouse")
@org.hibernate.annotations.Table(appliesTo = "dms_product_security_stock_quantity_warehouse", comment = "商品安全库存数量适用仓库表")
public class ProductSecurityStockQuantityWarehouse extends TenantOpEntity {


  /**
   * 安全库存数量id
   */
  @ApiModelProperty("安全库存数量id")
  @TableField("security_stock_quantity_id")
  @Column(name = "security_stock_quantity_id", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 安全库存数量id '")
  private String securityStockQuantityId;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  @TableField("warehouse_code")
  @Column(name = "warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库编码 '")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  @TableField(value = "warehouse_name")
  @Column(name = "warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库名称 '")
  private String warehouseName;


  @TableField(exist = false)
  @Transient
  private ProductSecurityStockQuantity securityStockQuantity;

}
