package com.biz.crm.dms.business.psi.product.local.entity.productstock;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * <p>
 * 商品库存明细表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductStockDetail", description = "商品库存明细表")
@TableName("dms_product_stock_detail")
@Entity
@Table(name = "dms_product_stock_detail")
@org.hibernate.annotations.Table(appliesTo = "dms_product_stock_detail", comment = "商品库存明细表")
public class ProductStockDetail extends TenantOpEntity {


  /**
   * 库存id
   */
  @ApiModelProperty("库存id")
  @TableField("stock_id")
  @Column(name = "stock_id", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 库存id '")
  private String stockId;

  /**
   * 库存编码
   */
  @ApiModelProperty("库存编码")
  @TableField("stock_code")
  @Column(name = "stock_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 库存编码 '")
  private String stockCode;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  @TableField("warehouse_code")
  @Column(name = "warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库编码 '")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  @TableField("warehouse_name")
  @Column(name = "warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库名称 '")
  private String warehouseName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @TableField("product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @TableField("product_name")
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品名称 '")
  private String productName;

  /**
   * 商品库存操作
   */
  @ApiModelProperty("商品库存操作")
  @TableField(value = "product_stock_operation")
  @Column(name = "product_stock_operation", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品库存操作 '")
  private ProductStockOperation productStockOperation;

  /**
   * 商品库存操作类型
   */
  @ApiModelProperty("商品库存操作类型")
  @TableField(value = "product_stock_operation_type")
  @Column(name = "product_stock_operation_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品库存操作类型 '")
  private String productStockOperationType;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @TableField("customer_code")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户编码 '")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @TableField("customer_name")
  @Column(name = "customer_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户名称 '")
  private String customerName;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  @TableField("original_order_code")
  @Column(name = "original_order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 原始订单编号 '")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @TableField(value = "order_type")
  @Column(name = "order_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单类型 '")
  private String orderType;

  /**
   * 订单编号
   */
  @ApiModelProperty("订单编号")
  @TableField("order_code")
  @Column(name = "order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单编号 '")
  private String orderCode;

  /**
   * 订单行编号
   */
  @ApiModelProperty("订单行编号")
  @TableField("order_item_code")
  @Column(name = "order_item_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单行编号 '")
  private String orderItemCode;

  /**
   * 关联商品库存单据类型
   */
  @ApiModelProperty("关联商品库存单据类型")
  @TableField(value = "bill_type")
  @Column(name = "bill_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联商品库存单据类型 '")
  private String billType;

  /**
   * 关联商品库存单据编号
   */
  @ApiModelProperty("关联商品库存单据编号")
  @TableField("bill_code")
  @Column(name = "bill_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联商品库存单据编号 '")
  private String billCode;

  /**
   * 本单库存操作商品数量
   */
  @ApiModelProperty("本单库存操作商品数量")
  @TableField(value = "stock_quantity")
  @Column(name = "stock_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 本单库存操作商品数量 '")
  private BigDecimal stockQuantity;

  /**
   * 总库存商品数量;记录的是本次操作完成后的库存商品总量
   */
  @ApiModelProperty("总库存商品数量")
  @TableField(value = "total_stock_quantity")
  @Column(name = "total_stock_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 总库存商品数量 '")
  private BigDecimal totalStockQuantity;

  /**
   * 本单占用库存商品数量
   */
  @ApiModelProperty("本单占用库存商品数量")
  @TableField(value = "frozen_quantity")
  @Column(name = "frozen_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 本单占用库存商品数量 '")
  private BigDecimal frozenQuantity;

  /**
   * 总占用库存商品数量;记录的是本次操作完成后的库存商品占用总量
   */
  @ApiModelProperty("总占用库存商品数量")
  @TableField(value = "total_frozen_quantity")
  @Column(name = "total_frozen_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 总占用库存商品数量 '")
  private BigDecimal totalFrozenQuantity;

}
