package com.biz.crm.dms.business.psi.product.local.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.dms.business.psi.product.sdk.enums.store.ProductStoreStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * <p>
 * 商品入库单表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductDeliveryBill", description = "商品入库单表")
@TableName("dms_product_stored_bill")
@Entity
@Table(name = "dms_product_stored_bill")
@org.hibernate.annotations.Table(appliesTo = "dms_product_stored_bill", comment = "商品入库单表")
public class ProductStoredBill extends TenantFlagOpEntity {

  /**
   * 入库单编码
   */
  @ApiModelProperty("入库单编码")
  @TableField("stored_bill_code")
  @Column(name = "stored_bill_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 入库单编码 '")
  private String storedBillCode;

  /**
   * 入库时间
   */
  @ApiModelProperty("入库时间")
  @TableField(value = "stored_time")
  @Column(name = "stored_time", length = 20, columnDefinition = "datetime COMMENT '入库时间'")
  private Date storedTime;

  /**
   * 经办人账号
   */
  @ApiModelProperty("经办人账号")
  @TableField("handler_account")
  @Column(name = "handler_account", length = 60, columnDefinition = "varchar(60) COMMENT '经办人账号'")
  private String handlerAccount;

  /**
   * 经办人姓名
   */
  @ApiModelProperty("经办人姓名")
  @TableField("handler_name")
  @Column(name = "handler_name", length = 60, columnDefinition = "varchar(60) COMMENT '经办人姓名'")
  private String handlerName;

  /**
   * 关联收货单类型
   */
  @ApiModelProperty("关联收货单类型")
  @TableField(value = "relation_receiving_order_type")
  @Column(name = "relation_receiving_order_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联收货单类型 '")
  private String relationReceivingOrderType;

  /**
   * 关联收货单编码
   */
  @ApiModelProperty("关联收货单编码")
  @TableField(value = "relation_receiving_order_code")
  @Column(name = "relation_receiving_order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 关联收货单编码 '")
  private String relationReceivingOrderCode;

  /**
   * 入库仓库编码
   */
  @ApiModelProperty("入库仓库编码")
  @TableField(value = "store_warehouse_code")
  @Column(name = "store_warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 入库仓库编码 '")
  private String storeWarehouseCode;

  /**
   * 入库仓库名称
   */
  @ApiModelProperty("入库仓库名称")
  @TableField(value = "store_warehouse_name")
  @Column(name = "store_warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 入库仓库名称 '")
  private String storeWarehouseName;

  /**
   * 出库仓库编码
   */
  @ApiModelProperty("出库仓库编码")
  @TableField(value = "delivery_warehouse_code")
  @Column(name = "delivery_warehouse_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库仓库编码 '")
  private String deliveryWarehouseCode;

  /**
   * 出库仓库名称
   */
  @ApiModelProperty("出库仓库名称")
  @TableField(value = "delivery_warehouse_name")
  @Column(name = "delivery_warehouse_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 出库仓库名称 '")
  private String deliveryWarehouseName;

  /**
   * 入库状态
   */
  @ApiModelProperty("入库状态")
  @TableField(value = "stored_status")
  @Column(name = "stored_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 入库状态 '")
  private ProductStoreStatus storedStatus;

  /**
   * 商品库存操作类型
   */
  @ApiModelProperty("商品库存操作类型")
  @TableField(value = "product_stock_operation_type")
  @Column(name = "product_stock_operation_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品库存操作类型 '")
  private String productStockOperationType;

  /**
   * 类型(商品：product; 物料：material)
   */
  @ApiModelProperty("类型(商品：product; 物料：material)")
  @TableField(value = "type")
  @Column(name = "type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 类型(商品：product; 物料：material) '")
  private String type;
}
