package com.biz.crm.dms.business.psi.product.local.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * <p>
 * 商品入库单明细表
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductStoredBillDetail", description = "商品入库单明细表")
@TableName("dms_product_stored_bill_detail")
@Entity
@Table(name = "dms_product_stored_bill_detail")
@org.hibernate.annotations.Table(appliesTo = "dms_product_stored_bill_detail", comment = "商品入库单明细表")
public class ProductStoredBillDetail extends TenantOpEntity {


  /**
   * 入库单id
   */
  @ApiModelProperty("入库单id")
  @TableField("stored_bill_id")
  @Column(name = "stored_bill_id", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 入库单id '")
  private String storedBillId;

  /**
   * 入库单编码
   */
  @ApiModelProperty("入库单编码")
  @TableField(value = "stored_bill_code")
  @Column(name = "stored_bill_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 入库单编码 '")
  private String storedBillCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @TableField("customer_code")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户编码 '")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @TableField("customer_name")
  @Column(name = "customer_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户名称 '")
  private String customerName;

  /**
   * 原始订单编号
   */
  @ApiModelProperty("原始订单编号")
  @TableField("original_order_code")
  @Column(name = "original_order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 原始订单编号 '")
  private String originalOrderCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @TableField(value = "order_type")
  @Column(name = "order_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单类型 '")
  private String orderType;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @TableField(value = "order_code")
  @Column(name = "order_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单编码 '")
  private String orderCode;

  /**
   * 订单行明细编码
   */
  @ApiModelProperty("订单行明细编码")
  @TableField(value = "order_item_code")
  @Column(name = "order_item_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 订单行明细编码 '")
  private String orderItemCode;

  /**
   * 行项目类型
   */
  @ApiModelProperty("行项目类型")
  @TableField(value = "item_type")
  @Column(name = "item_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 行项目类型 '")
  private String itemType;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @TableField(value = "product_name")
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品名称 '")
  private String productName;

  /**
   * 物料类别
   */
  @ApiModelProperty("物料类别")
  @TableField(value = "material_type")
  @Column(name = "material_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料类别 '")
  private String materialType;

  /**
   * 物料类别名称
   */
  @ApiModelProperty("物料类别名称")
  @TableField(value = "material_type_name")
  @Column(name = "material_type_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料类别名称 '")
  private String materialTypeName;

  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  @TableField(value = "product_level_code")
  @Column(name = "product_level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品层级编码 '")
  private String productLevelCode;

  /**
   * 商品层级
   */
  @ApiModelProperty("商品层级")
  @TableField(value = "product_level")
  @Column(name = "product_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品层级 '")
  private String productLevel;

  /**
   * 商品规格
   */
  @ApiModelProperty("商品规格")
  @TableField(value = "product_spec")
  @Column(name = "product_spec", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品规格 '")
  private String productSpec;

  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  @TableField(value = "product_unit")
  @Column(name = "product_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品单位 '")
  private String productUnit;

  /**
   * 收货单行项id
   */
  @ApiModelProperty("收货单行项id")
  @TableField("receiving_item_id")
  @Column(name = "receiving_item_id", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 收货单行项id '")
  private String receivingItemId;

  /**
   * 收货单行项总数
   */
  @ApiModelProperty("收货单行项总数")
  @TableField(value = "receiving_item_quantity")
  @Column(name = "receiving_item_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 收货单行项总数 '")
  private BigDecimal receivingItemQuantity;

  /**
   * 入库数
   */
  @ApiModelProperty("入库数")
  @TableField(value = "stored_quantity")
  @Column(name = "stored_quantity", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 入库数 '")
  private BigDecimal storedQuantity;


}
