package com.biz.crm.dms.business.psi.product.local.mapper.delivery;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.delivery.ProductDeliveryBill;
import com.biz.crm.dms.business.psi.product.sdk.dto.delivery.ProductDeliveryBillPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.delivery.ProductDeliveryBillVo;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 商品出库单表 Mapper 接口
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-15
 */
public interface ProductDeliveryBillMapper extends BaseMapper<ProductDeliveryBill> {

  /**
   * 分页查询
   *
   * @param page
   * @param paginationDto
   * @param normal
   * @return
   */
  Page<ProductDeliveryBillVo> findByConditions(Page<ProductDeliveryBillVo> page,
                                               @Param("dto") ProductDeliveryBillPaginationDto paginationDto,
                                               @Param("delFlag") DelFlagStatusEnum normal);
}
