package com.biz.crm.dms.business.psi.product.local.mapper.productstock;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductSecurityStock;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockConditionDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductSecurityStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductSecurityStockVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 商品安全库存表 Mapper 接口
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-07
 */
public interface ProductSecurityStockMapper extends BaseMapper<ProductSecurityStock> {

  /**
   * 分页查询
   *
   * @param page
   * @param paginationDto
   * @param normal
   * @return
   */
  Page<ProductSecurityStockVo> findByConditions(Page<ProductSecurityStockVo> page,
                                                @Param("dto") ProductSecurityStockPaginationDto paginationDto,
                                                @Param("delFlag") DelFlagStatusEnum normal);

  /**
   * 查询详情
   *
   * @param id
   * @param tenantCode
   * @return
   */
  ProductSecurityStockVo findDetailsById(@Param("id") String id, @Param("tenantCode") String tenantCode);

  /**
   * 通过产品编码查询详情
   * @param productCode
   * @param tenantCode
   * @return
   */
  List<ProductSecurityStockVo> findDetailsByConditions(
      @Param("dto") ProductSecurityStockConditionDto dtp
      ,@Param("tenantCode") String tenantCode
      ,@Param("delFlag")String delFlag
      ,@Param("enableStatus")String enableStatus);
}
