package com.biz.crm.dms.business.psi.product.local.mapper.productstock;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockPaginationDto;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 商品库存表 Mapper 接口
 * </p>
 *
 * @author Bao Hongbin
 * @since 2022-01-11
 */
public interface ProductStockMapper extends BaseMapper<ProductStock> {

  /**
   * 分页查询
   * @param page
   * @param paginationDto
   * @param normal
   * @return
   */
  Page<ProductStockVo> findByConditions(Page<ProductStockVo> page,
                                        @Param("dto") ProductStockPaginationDto paginationDto,
                                        @Param("delFlag") DelFlagStatusEnum normal);

  /**
   * 根据商品编码查询
   * @param productCodes
   * @param normal
   * @return
   */
  List<ProductStockVo> findByProductCodes(@Param("productCodes") List<String> productCodes, @Param("normal") DelFlagStatusEnum normal);
}
