package com.biz.crm.dms.business.psi.product.local.register.store.internal;
/**
 * Created by Bao Hongbin on 2022-01-13 14:57.
 */

import com.biz.crm.dms.business.psi.product.local.entity.productstock.ProductStock;
import com.biz.crm.dms.business.psi.product.local.service.productstock.ProductStockService;
import com.biz.crm.dms.business.psi.product.sdk.common.constant.ProductStockConstant;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.StoredProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.register.store.StoredBillProductStockRegister;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

/**
 * @program: crm-dms
 * @description: 物料入库库存操作注册器实现
 * @author: Bao Hongbin
 * @create: 2022-01-13 14:57
 **/
@Service("PurchaseStoreMaterialStockRegister")
public class PurchaseStoreMaterialStockRegister implements StoredBillProductStockRegister {

  /**
   * @see com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType
   */
  private final String OPERATION_TYPE = "MATERIAL_STORE";

  private final String VOID_OPERATION_TYPE = "VOID_MATERIAL_STORE";

  @Autowired(required = false)
  private ProductStockService productStockService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private RedissonClient redissonClient;

  @Override
  public String getOperationType() {
    return OPERATION_TYPE;
  }

  @Override
  @Transactional
  public ProductStockVo execute(StoredProductStockOperationDto operationDto) {
    Validate.notNull(operationDto.getWarehouseCode(), "变更库存物料数量时仓库编码不能为空");
    Validate.notNull(operationDto.getProductCode(), "变更库存物料数量时商品编码不能为空");
    Validate.notNull(operationDto.getQuantity(), "变更库存物料数量不能为空");
    ProductStockOperationDto productStockOperationDto = nebulaToolkitService.copyObjectByWhiteList(
        operationDto, ProductStockOperationDto.class, HashSet.class, ArrayList.class);
    TransactionStatus transactionStatus = null;
    //添加分布式锁
    RLock rLock = redissonClient.getLock(String.format(
        ProductStockConstant.PRODUCT_STOCK_LOCK,
        productStockOperationDto.getWarehouseCode(),
        productStockOperationDto.getProductCode()
    ));
    rLock.lock(5000, TimeUnit.MILLISECONDS);
    try {
      //设置库存操作类型
      productStockOperationDto.setProductStockOperationType(OPERATION_TYPE);
      //入库
      ProductStock productStock = productStockService.store(productStockOperationDto);
      ProductStockVo productStockVo = nebulaToolkitService.copyObjectByWhiteList(
          productStock, ProductStockVo.class, HashSet.class, ArrayList.class);
      return productStockVo;
    } finally {
      //事务提交或回滚后解锁
      rLock.unlock();
    }
  }

  @Override
  @Transactional
  public ProductStockVo rescind(StoredProductStockOperationDto operationDto) {
    Validate.notNull(operationDto.getWarehouseCode(), "变更库存物料数量时仓库编码不能为空");
    Validate.notNull(operationDto.getProductCode(), "变更库存物料数量时商品编码不能为空");
    Validate.notNull(operationDto.getQuantity(), "变更库存物料数量不能为空");
    ProductStockOperationDto productStockOperationDto = nebulaToolkitService.copyObjectByWhiteList(
        operationDto, ProductStockOperationDto.class, HashSet.class, ArrayList.class);
    TransactionStatus transactionStatus = null;
    //添加分布式锁
    RLock rLock = redissonClient.getLock(String.format(
        ProductStockConstant.PRODUCT_STOCK_LOCK,
        productStockOperationDto.getWarehouseCode(),
        productStockOperationDto.getProductCode()
    ));
    rLock.lock(5000, TimeUnit.MILLISECONDS);
    try {
      //设置库存操作类型
      productStockOperationDto.setProductStockOperationType(VOID_OPERATION_TYPE);
      //出库
      ProductStock productStock = productStockService.deliver(productStockOperationDto);
      ProductStockVo productStockVo = nebulaToolkitService.copyObjectByWhiteList(
          productStock, ProductStockVo.class, HashSet.class, ArrayList.class);
      return productStockVo;
    } finally {
      //事务提交或回滚后解锁
      rLock.unlock();
    }
  }
}
